/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.index.testimpact.ImpactReason;
import com.teamscale.index.testimpact.MethodId;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyValueCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

@Index(name="impacted-tests", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={String.class, ImpactReason.class, MethodId.class})
public class ImpactedTestsIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "impacted-tests";

    public ImpactedTestsIndex(IStore store) {
        super(store);
    }

    void insertOrReplaceImpactedTests(Map<PartitionAndPath, ImpactReason> impactedTests) throws StorageException {
        Set<String> uniformPaths = ImpactedTestsIndex.collectUniformPaths(impactedTests);
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(uniformPaths);
        PairList entries = new PairList();
        for (Map.Entry<PartitionAndPath, ImpactReason> impactedTestEntry : impactedTests.entrySet()) {
            PartitionAndPath test = impactedTestEntry.getKey();
            byte[] serializedImpactReason = ImpactedTestsIndex.serializeImpactReason(impactedTestEntry.getValue(), abbreviationMap);
            entries.add((Object)ImpactedTestsIndex.makeKey(test.getPartition(), test.getUniformPath(), abbreviationMap), (Object)serializedImpactReason);
        }
        this.store.put(entries);
    }

    private static Set<String> collectUniformPaths(Map<PartitionAndPath, ImpactReason> impactedTests) {
        HashSet<String> uniformPathsAndPartitions = new HashSet<String>();
        for (Map.Entry<PartitionAndPath, ImpactReason> entry : impactedTests.entrySet()) {
            uniformPathsAndPartitions.add(entry.getKey().getUniformPath());
            uniformPathsAndPartitions.add(entry.getKey().getPartition());
            HashMap<MethodId, Long> changedMethods = entry.getValue().getChangedMethods();
            for (MethodId reason : changedMethods.keySet()) {
                uniformPathsAndPartitions.add(reason.getUniformPath().toString());
            }
        }
        return uniformPathsAndPartitions;
    }

    private static byte[] makeKey(String partition, String uniformPath, Map<String, Integer> abbreviationMap) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviationMap.get(partition)), ByteArrayUtils.intToByteArray((int)abbreviationMap.get(uniformPath))});
    }

    public Map<PartitionAndPath, ImpactReason> getAllImpactedTestsOnPartitions(List<String> partitions) throws StorageException {
        PairList scannedResults = new PairList();
        this.store.scan(this.store.getAbbreviator().abbreviate(partitions).stream().map(ByteArrayUtils::intToByteArray).toList(), (IKeyValueCallback)new KeyValueCollectingCallback(scannedResults));
        return this.deserializeRawResults((PairList<byte[], byte[]>)scannedResults);
    }

    private @NonNull Map<PartitionAndPath, ImpactReason> deserializeRawResults(PairList<byte[], byte[]> scannedResults) throws StorageException {
        Map<Integer, String> unabbreviationMap = ImpactedTestsIndex.createUnabbreviationMap(scannedResults, this.store.getAbbreviator());
        HashMap<PartitionAndPath, ImpactReason> result = new HashMap<PartitionAndPath, ImpactReason>();
        for (Pair keyAndValue : scannedResults) {
            result.put(new PartitionAndPath(unabbreviationMap.get(ByteArrayUtils.readIntFromStartOfArray((byte[])((byte[])keyAndValue.getFirst()))), unabbreviationMap.get(ByteArrayUtils.getIntFromByteArray((byte[])((byte[])keyAndValue.getFirst()), (int)4))), ImpactedTestsIndex.deserializeImpactReason((byte[])keyAndValue.getSecond(), unabbreviationMap));
        }
        return result;
    }

    public Map<PartitionAndPath, ImpactReason> getAllImpactedTests() throws StorageException {
        PairList scannedResults = new PairList();
        this.store.scan(new byte[0], (IKeyValueCallback)new KeyValueCollectingCallback(scannedResults));
        return this.deserializeRawResults((PairList<byte[], byte[]>)scannedResults);
    }

    private static ImpactReason deserializeImpactReason(byte[] value, Map<Integer, String> unabbreviationMap) {
        int currentOffSet = 0;
        Long timestampOfLastChange = ByteArrayUtils.getLongFromByteArray((byte[])value, (int)currentOffSet);
        if (timestampOfLastChange == -1L) {
            timestampOfLastChange = null;
        }
        ETestExecutionResult lastTestExecutionResult = null;
        int ordinal = ByteArrayUtils.getIntFromByteArray((byte[])value, (int)(currentOffSet += 8));
        if (ordinal != -1) {
            lastTestExecutionResult = ETestExecutionResult.values()[ordinal];
        }
        HashMap<MethodId, Long> changedMethods = new HashMap<MethodId, Long>();
        for (int i = currentOffSet += 4; i < value.length; i += 16) {
            UniformPath uniformPath = UniformPath.parse((String)unabbreviationMap.get(ByteArrayUtils.getIntFromByteArray((byte[])value, (int)i)));
            int methodId = ByteArrayUtils.getIntFromByteArray((byte[])value, (int)(i + 4));
            long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])value, (int)(i + 8));
            changedMethods.put(new MethodId(uniformPath, methodId), timestamp);
        }
        return new ImpactReason(timestampOfLastChange, changedMethods, lastTestExecutionResult);
    }

    private static Map<Integer, String> createUnabbreviationMap(PairList<byte[], byte[]> serializedEntries, StorageStringAbbreviator abbreviator) throws StorageException {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Pair entry : serializedEntries) {
            int partitionId = ByteArrayUtils.readIntFromStartOfArray((byte[])((byte[])entry.getFirst()));
            int uniformPathId = ByteArrayUtils.getIntFromByteArray((byte[])((byte[])entry.getFirst()), (int)4);
            ids.add(partitionId);
            ids.add(uniformPathId);
            for (int i = 12; i < ((byte[])entry.getSecond()).length; i += 16) {
                ids.add(ByteArrayUtils.getIntFromByteArray((byte[])((byte[])entry.getSecond()), (int)i));
            }
        }
        return abbreviator.buildUnabbreviationMap(ids);
    }

    public void removeCoverageUnits(Collection<PartitionAndPath> tests) throws StorageException {
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(ImpactedTestsIndex.collectUniformPaths(tests));
        ArrayList<byte[]> keysToRemove = new ArrayList<byte[]>();
        for (PartitionAndPath test : tests) {
            keysToRemove.add(ImpactedTestsIndex.makeKey(test.getPartition(), test.getUniformPath(), abbreviationMap));
        }
        this.store.remove(keysToRemove);
    }

    private static Set<String> collectUniformPaths(Collection<PartitionAndPath> tests) {
        HashSet<String> uniformPathsAndPartitions = new HashSet<String>();
        for (PartitionAndPath partitionAndPath : tests) {
            uniformPathsAndPartitions.add(partitionAndPath.getUniformPath());
            uniformPathsAndPartitions.add(partitionAndPath.getPartition());
        }
        return uniformPathsAndPartitions;
    }

    private static byte[] serializeImpactReason(ImpactReason impactReason, Map<String, Integer> abbreviationMap) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Long timestampOfLastChange = impactReason.getTimestampOfLastChange();
        if (timestampOfLastChange == null) {
            timestampOfLastChange = -1L;
        }
        outputStream.writeBytes(ByteArrayUtils.longToByteArray((long)timestampOfLastChange));
        ETestExecutionResult lastTestExecutionResult = impactReason.getLastTestExecutionResult();
        int ordinal = -1;
        if (lastTestExecutionResult != null) {
            ordinal = lastTestExecutionResult.ordinal();
        }
        outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)ordinal));
        HashMap<MethodId, Long> methods = impactReason.getChangedMethods();
        for (Map.Entry<MethodId, Long> entry : methods.entrySet()) {
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)abbreviationMap.get(entry.getKey().getUniformPath().toString())));
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)entry.getKey().getId()));
            outputStream.writeBytes(ByteArrayUtils.longToByteArray((long)entry.getValue()));
        }
        return outputStream.toByteArray();
    }
}

