/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
class MethodLocationOffsetMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, OffsetBasedRegion> mapping = new HashMap<Integer, OffsetBasedRegion>();
    private transient Map<OffsetBasedRegion, Integer> reverseMapping;
    private int nextId = Integer.MIN_VALUE;
    private transient boolean updated = false;

    public MethodLocationOffsetMapping() {
    }

    public MethodLocationOffsetMapping(MethodLocationOffsetMapping methodLocationOffsetMapping) {
        this.mapping.putAll(methodLocationOffsetMapping.mapping);
        this.nextId = methodLocationOffsetMapping.nextId;
        this.updated = methodLocationOffsetMapping.updated;
    }

    public Integer getId(OffsetBasedRegion region) {
        this.ensureReverseMappingExists();
        return this.reverseMapping.get(region);
    }

    public int getOrInsertRegion(OffsetBasedRegion offsetBasedRegion) {
        this.ensureReverseMappingExists();
        return this.reverseMapping.computeIfAbsent(offsetBasedRegion, region -> {
            int newId = this.nextId++;
            this.mapping.put(newId, (OffsetBasedRegion)region);
            this.updated = true;
            return newId;
        });
    }

    public void changeRegion(int id, OffsetBasedRegion newRegion) {
        OffsetBasedRegion previousRegion = this.mapping.put(id, newRegion);
        if (this.reverseMapping != null) {
            this.reverseMapping.remove(previousRegion);
            this.reverseMapping.put(newRegion, id);
        }
        this.updated = true;
    }

    public void removeId(int id) {
        OffsetBasedRegion region = this.mapping.remove(id);
        if (this.reverseMapping != null) {
            this.reverseMapping.remove(region);
        }
        this.updated = true;
    }

    public OffsetBasedRegion getLocation(int id) {
        return this.mapping.get(id);
    }

    private void ensureReverseMappingExists() {
        if (this.reverseMapping != null) {
            return;
        }
        this.reverseMapping = new HashMap<OffsetBasedRegion, Integer>();
        this.mapping.forEach((region, id) -> this.reverseMapping.put((OffsetBasedRegion)id, (Integer)region));
    }

    public boolean isEmpty() {
        return this.mapping.isEmpty();
    }

    public boolean hasBeenUpdated() {
        return this.updated;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.nextId);
        out.writeInt(this.mapping.size());
        for (Map.Entry<Integer, OffsetBasedRegion> entry : this.mapping.entrySet()) {
            out.writeInt(entry.getKey());
            out.writeInt(entry.getValue().getStart());
            out.writeInt(entry.getValue().getEnd());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.nextId = in.readInt();
        int count = in.readInt();
        this.mapping = new HashMap<Integer, OffsetBasedRegion>();
        for (int i = 0; i < count; ++i) {
            int id = in.readInt();
            int startOffset = in.readInt();
            int endOffset = in.readInt();
            this.mapping.put(id, new OffsetBasedRegion(startOffset, endOffset));
        }
        this.reverseMapping = null;
        this.updated = false;
    }
}

