/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testimpact.CodeToTestPathsMapIndex;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.index.tests.extractor.ITestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.TestCaseExtractionStrategyFactory;
import com.teamscale.index.tests.extractor.TestPathLookupIndex;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.NonNull;

public class TestCaseExtractionSynchronizer
extends ChangeProcessorAnalysisStep {
    public static final String CUSTOM_FRAMEWORK_TEST_DETECTION_PATTERNS = "custom-framework-test-detection-patterns";
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    protected KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    protected TokenElementIndex tokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected TestImplementationIndex testImplementationIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected CodeToTestPathsMapIndex codeToTestPathsMapIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected TestPathLookupIndex testPathLookupIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected TypeIndex typeIndex;
    private TypeIndexCache typeIndexCache;
    @StepParameter(value="custom-framework-test-detection-patterns", optional=true)
    protected PairList<String, String> testDetectionPatterns = new PairList();
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws StorageException {
        if (EFeatureToggle.DISABLE_TEST_CASE_EXTRACTION.isEnabled()) {
            return;
        }
        this.typeIndexCache = new TypeIndexCache(this.typeIndex);
        PairList<String, HashSet<String>> codePathsToDiscoveredTestPaths = this.processAddedOrChangedCodeFiles();
        this.processDeletedTests(codePathsToDiscoveredTestPaths);
        this.codeToTestPathsMapIndex.setCodeToTestPathMappings(codePathsToDiscoveredTestPaths);
    }

    private PairList<String, HashSet<String>> processAddedOrChangedCodeFiles() throws StorageException {
        PairList codePathsToDiscoveredTestPaths = new PairList();
        PairList discoveredTests = new PairList();
        List<TokenElementInfo> addedOrChangedFiles = this.tokenElementIndex.getTokenElements(this.contentDelta.getAddedOrChangedKeysAsStrings());
        for (TokenElementInfo addedOrChangedFile : addedOrChangedFiles) {
            PairList<String, TestImplementation> testsInFile = this.extractTestsInFile(addedOrChangedFile);
            codePathsToDiscoveredTestPaths.add((Object)addedOrChangedFile.getUniformPath(), new HashSet(testsInFile.getFirstList()));
            discoveredTests.addAll(testsInFile);
        }
        this.removeRenamedTestNamesFromTestPathLookup((PairList<String, TestImplementation>)discoveredTests);
        this.testImplementationIndex.setTestImplementation(this.getSchedulingCommit(), (PairList<UniformPath, TestImplementation>)PairList.zip((List)UniformPathCompatibilityUtil.convertCollection((Collection)discoveredTests.getFirstList()), (List)discoveredTests.extractSecondList()));
        this.testPathLookupIndex.addPaths((PairList<String, String>)discoveredTests.mapSecond(TestImplementation::getName));
        return codePathsToDiscoveredTestPaths;
    }

    private void removeRenamedTestNamesFromTestPathLookup(PairList<String, TestImplementation> discoveredTests) throws StorageException {
        List<TestImplementation> previousTestImplementations = this.testImplementationIndex.getTestImplementations((List<String>)discoveredTests.getFirstList());
        PairList renamedTestImplementations = new PairList();
        CollectionUtils.forEach(discoveredTests, previousTestImplementations, (discoveredTest, previousTestImplementation) -> {
            if (previousTestImplementation == null) {
                return;
            }
            String testUniformPath = (String)discoveredTest.getFirst();
            TestImplementation testImplementation = (TestImplementation)discoveredTest.getSecond();
            if (!previousTestImplementation.getName().equals(testImplementation.getName())) {
                renamedTestImplementations.add((Object)testUniformPath, (Object)previousTestImplementation.getName());
            }
        });
        this.testPathLookupIndex.removePaths((PairList<String, String>)renamedTestImplementations);
    }

    private @NonNull PairList<String, TestImplementation> extractTestsInFile(TokenElementInfo addedOrChangedFile) {
        List<ITestCaseExtractionStrategy> extractionStrategies = TestCaseExtractionStrategyFactory.getStrategies(addedOrChangedFile.getLanguage(), this.testDetectionPatterns);
        PairList testsInFile = new PairList();
        for (ITestCaseExtractionStrategy strategy : extractionStrategies) {
            String uniformPath = addedOrChangedFile.getUniformPath();
            if (UniformPathUtils.isArchitectureFile((String)uniformPath)) continue;
            try {
                PairList<String, TestImplementation> testsByName = strategy.extractTestCases(new TokenElementTransformContext(addedOrChangedFile), this.typeIndexCache);
                testsInFile.addAll(testsByName);
            }
            catch (StorageException e) {
                LOGGER.error("Failed to extract test cases for file: " + addedOrChangedFile.getUniformPath(), (Throwable)e);
            }
        }
        return testsInFile;
    }

    private void processDeletedTests(PairList<String, HashSet<String>> discoveredTestImplementationPaths) throws StorageException {
        List<String> deletedTestPaths = this.computeDeletedTestPaths(discoveredTestImplementationPaths);
        if (!deletedTestPaths.isEmpty()) {
            List<TestImplementation> deletedTestImplementations = this.testImplementationIndex.getTestImplementations(deletedTestPaths);
            this.testImplementationIndex.removeTestImplementations(deletedTestPaths);
            PairList testPathsAndNamesToDelete = PairList.zip(deletedTestPaths, deletedTestImplementations).filter((path, implementation) -> implementation != null).mapSecond(TestImplementation::getName);
            this.testPathLookupIndex.removePaths((PairList<String, String>)testPathsAndNamesToDelete);
        }
        this.codeToTestPathsMapIndex.removeCodeToTestPathsMappings(this.contentDelta.getDeletedKeysAsStrings());
    }

    private @NonNull List<String> computeDeletedTestPaths(PairList<String, HashSet<String>> discoveredTestImplementationPaths) throws StorageException {
        List<String> previouslyExistingTestImplementationPaths = this.codeToTestPathsMapIndex.getFlatListOfContainedTestPaths(this.contentDelta.getAllKeysAsStrings());
        for (Pair discovered : discoveredTestImplementationPaths) {
            ((HashSet)discovered.getSecond()).forEach(previouslyExistingTestImplementationPaths::remove);
        }
        return previouslyExistingTestImplementationPaths;
    }
}

