/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor.junit;

import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.tests.extractor.ITestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.TestCaseExtractionUtils;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class JUnitTestCaseExtractionStrategy
implements ITestCaseExtractionStrategy {
    @Override
    public PairList<String, TestImplementation> extractTestCases(TokenElementTransformContext context, TypeIndexCache typeIndex) {
        UnmodifiableList<ShallowEntity> shallowEntities = context.getShallowEntitiesWithPreprocessorTokens();
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType(shallowEntities, (EShallowEntityType)EShallowEntityType.METHOD);
        return (PairList)methods.stream().filter(method -> LanguageFeatureParser.JAVA.hasAnnotation(method, EJavaTestFramework.TEST_ANNOTATION_NAMES)).map(shallowEntity -> JUnitTestCaseExtractionStrategy.extractNameAndTestImplementation(context, shallowEntity)).collect(PairList.toPairList());
    }

    private static Pair<String, TestImplementation> extractNameAndTestImplementation(TokenElementTransformContext context, ShallowEntity shallowEntity) {
        String pathPrefix = LanguageFeatureParser.JAVA.getPackageName(context.getShallowEntitiesWithPreprocessorTokens()).map(packageName -> packageName.replace('.', '/') + UniformPathUtils.SEPARATOR).orElse("");
        String fullTestClassName = LanguageFeatureParser.JAVA.getFullClassName(shallowEntity);
        String testMethodName = shallowEntity.getName();
        String testName = pathPrefix + fullTestClassName + UniformPathUtils.SEPARATOR + testMethodName;
        UniformPath testPath = TestCaseExtractionUtils.convertToTestImplementationUniformPath(context.getUniformPath(), fullTestClassName, testMethodName);
        return TestCaseExtractionUtils.buildTestUniformPathWithTestImplementation(testName, context, testPath, shallowEntity);
    }
}

