/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor.nunit_mstest;

import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.tests.extractor.ITestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.TestCaseExtractionUtils;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import java.util.Set;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CsTestCaseExtractionStrategy
implements ITestCaseExtractionStrategy {
    public static final Set<String> NUNIT_TEST_ATTRIBUTE_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"Test", "TestCase", "TestCaseSource"});
    public static final Set<String> MSTEST_TEST_ATTRIBUTE_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"TestMethod", "DataTestMethod"});
    public static final Set<String> XUNIT_TEST_ATTRIBUTE_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"Fact", "Theory", "Observation"});
    private final Set<String> testAttributeNames;

    public CsTestCaseExtractionStrategy(Set<String> attributeNames) {
        this.testAttributeNames = attributeNames;
    }

    @Override
    public PairList<String, TestImplementation> extractTestCases(TokenElementTransformContext context, TypeIndexCache typeIndex) {
        UnmodifiableList<ShallowEntity> shallowEntities = context.getShallowEntitiesWithPreprocessorTokens();
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType(shallowEntities, (EShallowEntityType)EShallowEntityType.METHOD);
        return (PairList)methods.stream().filter(method -> LanguageFeatureParser.CS.hasAnnotation(method, this.testAttributeNames)).map(methodEntity -> CsTestCaseExtractionStrategy.extractNameAndTestImplementation(context, methodEntity)).collect(PairList.toPairList());
    }

    private static Pair<String, TestImplementation> extractNameAndTestImplementation(TokenElementTransformContext context, ShallowEntity methodEntity) {
        UnmodifiableList<ShallowEntity> entities = context.getShallowEntitiesWithPreprocessorTokens();
        String pathPrefix = LanguageFeatureParser.CS.getNamespace(entities).map(namespace -> namespace.replace('.', '/') + "/").orElse("");
        String testMethodName = methodEntity.getName();
        String fullTestClassName = CsTestCaseExtractionStrategy.buildTestClassPathForMethod(methodEntity);
        String testName = pathPrefix + fullTestClassName + UniformPathUtils.SEPARATOR + testMethodName;
        UniformPath testPath = TestCaseExtractionUtils.convertToTestImplementationUniformPath(context.getUniformPath(), fullTestClassName, testMethodName);
        return TestCaseExtractionUtils.buildTestUniformPathWithTestImplementation(testName, context, testPath, methodEntity);
    }

    private static String buildTestClassPathForMethod(ShallowEntity method) {
        StringBuilder testClassPath = new StringBuilder();
        for (ShallowEntity currentParent = method.getParent(); currentParent != null && currentParent.getType() == EShallowEntityType.TYPE && currentParent.getSubtype().equals("class"); currentParent = currentParent.getParent()) {
            testClassPath.insert(0, "+");
            testClassPath.insert(0, currentParent.getName());
        }
        testClassPath.deleteCharAt(testClassPath.length() - 1);
        return testClassPath.toString();
    }
}

