/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor.xctest;

import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.dependencies.type.Type;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.tests.extractor.ITestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.TestCaseExtractionUtils;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class XCTestTestCaseExtractionStrategyBase
implements ITestCaseExtractionStrategy {
    private static final Set<String> XCTEST_TEST_TYPES = Set.of("XCTest", "XCTestCase", "XCTestSuite");
    private static final String XCTEST_TEST_METHOD_PREFIX = "test";

    @Override
    public PairList<String, TestImplementation> extractTestCases(TokenElementTransformContext context, TypeIndexCache typeIndex) throws StorageException {
        PairList results = new PairList();
        UnmodifiableList<ShallowEntity> shallowEntities = context.getShallowEntitiesWithPreprocessorTokens();
        List<ShallowEntity> types = this.extractTypes(shallowEntities);
        HashMap<ShallowEntity, List<ShallowEntity>> classToXCTestMethodsMap = this.getEntityToXCTestMethodMap(types);
        for (Map.Entry<ShallowEntity, List<ShallowEntity>> entry : classToXCTestMethodsMap.entrySet()) {
            ShallowEntity clazz = entry.getKey();
            List<ShallowEntity> methods = entry.getValue();
            if (!this.isImplementationDescendantOfXCTest(clazz.getName(), typeIndex)) continue;
            for (ShallowEntity method : methods) {
                Pair<String, TestImplementation> nameAndTestImplementation = XCTestTestCaseExtractionStrategyBase.extractNameAndTestImplementation(context, clazz, method);
                results.add(nameAndTestImplementation);
            }
        }
        return results;
    }

    private HashMap<ShallowEntity, List<ShallowEntity>> getEntityToXCTestMethodMap(List<ShallowEntity> types) {
        HashMap<ShallowEntity, List<ShallowEntity>> classToXCTestMethodsMap = new HashMap<ShallowEntity, List<ShallowEntity>>();
        for (ShallowEntity type : types) {
            List<ShallowEntity> testMethods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)type.getChildren(), (EShallowEntityType)EShallowEntityType.METHOD).stream().filter(this::isXCTestMethod).toList();
            if (testMethods.isEmpty()) continue;
            classToXCTestMethodsMap.put(type, testMethods);
        }
        return classToXCTestMethodsMap;
    }

    private boolean isImplementationDescendantOfXCTest(@Nullable String className, TypeIndexCache typeIndex) throws StorageException {
        if (className == null || className.isEmpty()) {
            return false;
        }
        if (XCTEST_TEST_TYPES.contains(className)) {
            return true;
        }
        className = this.getSuperClass(className, typeIndex);
        return this.isImplementationDescendantOfXCTest(className, typeIndex);
    }

    private String getSuperClass(String className, TypeIndexCache typeIndex) throws StorageException {
        List<List<String>> fileList = typeIndex.getFilesForTypes(List.of(className));
        if (fileList.isEmpty()) {
            return null;
        }
        List<String> files = fileList.get(0);
        if (files.isEmpty()) {
            return null;
        }
        for (String file : files) {
            List<Type> types = typeIndex.getTypeInfo(file).getTypes();
            Type clazz = types.stream().filter(type -> type.getName().equals(className)).findFirst().get();
            List<String> superTypes = clazz.getSuperTypes();
            if (CollectionUtils.isNullOrEmpty(superTypes)) continue;
            return superTypes.get(0);
        }
        return null;
    }

    protected abstract List<ShallowEntity> extractTypes(UnmodifiableList<ShallowEntity> var1);

    private boolean isXCTestMethod(ShallowEntity method) {
        UnmodifiableList signatureTokens = method.ownStartTokens();
        if (signatureTokens.size() < this.getTestMethodSequence().length) {
            return false;
        }
        boolean hasNoParametersAndReturnsVoid = TokenStreamUtils.hasTokenTypeSequence((List)signatureTokens, (int)0, (ETokenType[])this.getTestMethodSequence());
        return hasNoParametersAndReturnsVoid && method.getName() != null && method.getName().startsWith(XCTEST_TEST_METHOD_PREFIX);
    }

    private static @NonNull Pair<String, TestImplementation> extractNameAndTestImplementation(TokenElementTransformContext context, ShallowEntity topLevelClass, ShallowEntity method) {
        String fullTestClassName = topLevelClass.getName();
        String testMethodName = method.getName();
        String testName = context.getUniformPath() + UniformPathUtils.SEPARATOR + fullTestClassName + UniformPathUtils.SEPARATOR + testMethodName;
        UniformPath testPath = TestCaseExtractionUtils.convertToTestImplementationUniformPath(context.getUniformPath(), fullTestClassName, testMethodName);
        return TestCaseExtractionUtils.buildTestUniformPathWithTestImplementation(testName, context, testPath, method);
    }

    protected abstract ETokenType[] getTestMethodSequence();
}

