/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.upload.cppcheck.data;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.teamscale.index.upload.cppcheck.data.CppcheckLocation;
import com.teamscale.index.upload.cppcheck.data.ECppcheckSeverity;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.List;

@XmlRootElement(name="error")
public class CppcheckError
implements Comparable<CppcheckError> {
    @XmlAttribute
    private String id;
    @XmlAttribute
    private ECppcheckSeverity severity;
    @XmlAttribute(name="msg")
    private String message;
    @XmlAttribute(name="verbose")
    private String verboseMessage;
    @XmlAttribute
    private boolean inconclusive;
    @XmlElement(name="location")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<CppcheckLocation> locations;
    @XmlElement(name="symbol")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<String> symbols;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ECppcheckSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(ECppcheckSeverity severity) {
        this.severity = severity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getVerboseMessage() {
        return this.verboseMessage;
    }

    public void setVerboseMessage(String verboseMessage) {
        this.verboseMessage = verboseMessage;
    }

    public boolean isInconclusive() {
        return this.inconclusive;
    }

    public void setInconclusive(boolean inconclusive) {
        this.inconclusive = inconclusive;
    }

    public List<CppcheckLocation> getLocations() {
        return this.locations;
    }

    public void setLocations(List<CppcheckLocation> locations) {
        this.locations = locations;
    }

    public List<String> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List<String> symbols) {
        this.symbols = symbols;
    }

    public CppcheckLocation getPrimaryLocation() {
        if (this.locations.size() <= 0) {
            return null;
        }
        return this.locations.get(0);
    }

    public List<CppcheckLocation> getSecondaryLocations() {
        if (this.locations.size() <= 1) {
            return Collections.emptyList();
        }
        return this.locations.subList(1, this.locations.size());
    }

    @Override
    public int compareTo(CppcheckError other) {
        if (this.severity == other.severity) {
            return this.id.compareTo(other.id);
        }
        return this.severity.compareTo(other.severity);
    }
}

