/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.usage_data;

import com.teamscale.index.usage_data.UserAgentParser;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="user-agents", options={EStorageOption.BACKUP})
public class UserAgentsIndex
implements IGlobalIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long DATA_EXPIRATION_PERIOD = Duration.ofDays(90L).toMillis();
    private static final String KEY_SEPARATOR = "#!#";
    private static final String TEAMSCALE_USER_AGENT_IDENTIFIER = "com.teamscale.";
    private static final Pattern TEAMSCALE_AGENT_PATTERN = Pattern.compile("(com\\.teamscale\\..*?)/\\s*(\\d+)");
    static final String INDEX_NAME = "user-agents";
    private final ValueIndex<Long> delegate;
    private final IStore store;

    public UserAgentsIndex(IStore store) {
        this.store = store;
        this.delegate = ValueIndex.forLong((IStore)store);
    }

    public void updateUserAgents(TwoDimHashMap<String, String, Long> userAgents) throws StorageException {
        PairList values = new PairList();
        for (String user : userAgents.getFirstKeys()) {
            for (String userAgent : userAgents.getSecondKeys((Object)user)) {
                if (StringUtils.isEmpty((String)userAgent)) {
                    LOGGER.error("Had an empty user agent in the input, which is not permitted!");
                    continue;
                }
                values.add((Object)UserAgentsIndex.createUserAgentKey(user, userAgent), (Object)((Long)userAgents.getValue((Object)user, (Object)userAgent)));
            }
        }
        this.delegate.setValues(values);
    }

    private static String createUserAgentKey(String user, String userAgentString) {
        if (userAgentString.startsWith(TEAMSCALE_USER_AGENT_IDENTIFIER)) {
            return UserAgentsIndex.createKey(user, userAgentString);
        }
        UserAgentParser.UserAgent userAgent = UserAgentParser.parse(userAgentString);
        return UserAgentsIndex.createKey(user, userAgent.family(), userAgent.major());
    }

    private static String createKey(String user, String product) {
        return user.replace(KEY_SEPARATOR, "_") + KEY_SEPARATOR + product.replace(KEY_SEPARATOR, "_");
    }

    private static String createKey(String user, String product, int majorVersion) {
        return user.replace(KEY_SEPARATOR, "_") + KEY_SEPARATOR + product.replace(KEY_SEPARATOR, "_") + KEY_SEPARATOR + majorVersion;
    }

    public void wipeExpiredData() throws StorageException {
        HashSet<String> keysToDelete = new HashSet<String>();
        PairList allEntries = this.delegate.getAllEntries();
        TwoDimHashMap latestProductVersion = new TwoDimHashMap();
        TwoDimHashMap equivalentTeamscaleUserMap = new TwoDimHashMap();
        for (int i = 0; i < allEntries.size(); ++i) {
            String key = (String)allEntries.getFirst(i);
            String[] parts = StringUtils.splitByWholeSeparator((String)key, (String)KEY_SEPARATOR, (int)3);
            if (parts.length < 2) {
                LOGGER.error("Encountered invalid key: {}. This is a sign of a malformed key. Please create a bug ticket.", (Object)key);
                keysToDelete.add(key);
            } else if (parts.length == 2) {
                user = parts[0];
                userAgent = parts[1];
                if (userAgent.startsWith(TEAMSCALE_USER_AGENT_IDENTIFIER)) {
                    UserAgentsIndex.handleTeamscalePlugins(keysToDelete, (TwoDimHashMap<String, String, Integer>)latestProductVersion, (TwoDimHashMap<String, String, HashMap<Integer, Set<String>>>)equivalentTeamscaleUserMap, user, userAgent);
                } else {
                    LOGGER.error("Encountered invalid key: {}. This is a sign of a malformed key. Please create a bug ticket.", (Object)key);
                    keysToDelete.add(key);
                }
            } else if (parts.length == 3) {
                user = parts[0];
                userAgent = parts[1];
                int majorVersion = Integer.parseInt(parts[2]);
                UserAgentsIndex.handleBrowser(keysToDelete, (TwoDimHashMap<String, String, Integer>)latestProductVersion, majorVersion, user, userAgent);
            }
            if (System.currentTimeMillis() - (Long)allEntries.getSecond(i) <= DATA_EXPIRATION_PERIOD) continue;
            keysToDelete.add(key);
        }
        this.delegate.removeValues(keysToDelete);
    }

    private static void handleTeamscalePlugins(Set<String> keysToDelete, TwoDimHashMap<String, String, Integer> latestProductVersion, TwoDimHashMap<String, String, HashMap<Integer, Set<String>>> equivalentTeamscaleUserMap, String user, String userAgent) {
        String product = UserAgentsIndex.extractIdentifierFromPluginUserAgent(userAgent);
        Integer majorVersion = UserAgentsIndex.extractMajorVersionFromPluginUserAgent(userAgent);
        Set equivalentUsers = ((HashMap)equivalentTeamscaleUserMap.computeIfAbsent((Object)user, (Object)product, (k1, k2) -> new HashMap())).computeIfAbsent(majorVersion, v -> new HashSet());
        equivalentUsers.add(userAgent);
        Integer latestVersion = (Integer)latestProductVersion.getValue((Object)user, (Object)product);
        if (latestVersion == null) {
            latestProductVersion.putValue((Object)user, (Object)product, (Object)majorVersion);
        } else if (latestVersion < majorVersion) {
            latestProductVersion.putValue((Object)user, (Object)product, (Object)majorVersion);
            for (String latestUserAgent : (Set)((HashMap)equivalentTeamscaleUserMap.getValue((Object)user, (Object)product)).get(latestVersion)) {
                keysToDelete.add(UserAgentsIndex.createKey(user, latestUserAgent));
            }
        } else if (latestVersion > majorVersion) {
            keysToDelete.add(UserAgentsIndex.createKey(user, userAgent));
        }
    }

    private static int extractMajorVersionFromPluginUserAgent(String userAgentString) {
        Matcher matcher = TEAMSCALE_AGENT_PATTERN.matcher(userAgentString);
        Optional<MatchResult> match = matcher.results().findFirst();
        if (match.isPresent()) {
            String majorVersion = match.get().group(2);
            try {
                return Integer.parseInt(majorVersion);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Not able to parse the major version from the user agent: {}", (Object)userAgentString);
                return 0;
            }
        }
        LOGGER.error("Not able to parse the major version from the user agent: {}", (Object)userAgentString);
        return 0;
    }

    private static String extractIdentifierFromPluginUserAgent(String userAgentString) {
        Matcher matcher = TEAMSCALE_AGENT_PATTERN.matcher(userAgentString);
        Optional<MatchResult> match = matcher.results().findFirst();
        if (match.isPresent()) {
            return match.get().group(1);
        }
        LOGGER.error("Not able to parse identifier from the user agent: {}", (Object)userAgentString);
        return userAgentString;
    }

    private static void handleBrowser(Set<String> keysToDelete, TwoDimHashMap<String, String, Integer> latestProductVersion, int majorVersion, String user, String browserFamily) {
        Integer latestVersion = (Integer)latestProductVersion.getValue((Object)user, (Object)browserFamily);
        if (latestVersion == null) {
            latestProductVersion.putValue((Object)user, (Object)browserFamily, (Object)majorVersion);
        } else if (latestVersion < majorVersion) {
            latestProductVersion.putValue((Object)user, (Object)browserFamily, (Object)majorVersion);
            keysToDelete.add(UserAgentsIndex.createKey(user, browserFamily, latestVersion));
        } else {
            keysToDelete.add(UserAgentsIndex.createKey(user, browserFamily, majorVersion));
        }
    }

    public CounterSet<String> getUserAgentFrequency() throws StorageException {
        CounterSet userAgentFrequency = new CounterSet();
        for (String key : StorageUtils.listStringKeys((IStore)this.store)) {
            String[] parts = StringUtils.splitByWholeSeparator((String)key, (String)KEY_SEPARATOR, (int)3);
            if (parts.length < 2) {
                LOGGER.error("Encountered invalid key: {}", (Object)key);
                continue;
            }
            if (parts.length == 2) {
                userAgentFrequency.inc((Object)parts[1]);
                continue;
            }
            userAgentFrequency.inc((Object)(parts[1] + " " + parts[2]));
        }
        return userAgentFrequency;
    }
}

