/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.repository.IRepositoryLogEntry;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class UserAliasLookup {
    private static final Set<String> VALID_DELIMITERS = Set.of(" ", ", ", ".");
    private static final SortedSet<String> KNOWN_SUFFIXES = Collections.synchronizedSortedSet(new TreeSet<String>(Comparator.comparing(String::length).reversed()));
    private final Map<String, User> allUsers = new HashMap<String, User>();
    private final Map<String, User> aliasLookup = new HashMap<String, User>();
    private final Map<String, User> fullNameLookup = new HashMap<String, User>();
    private final Map<String, User> eMailLookup = new HashMap<String, User>();
    private final long lastUserIndexChangeTimestamp;
    private static @Nullable UserAliasLookup instanceWithLastChangeTimestamp = null;

    @VisibleForTesting
    public UserAliasLookup(List<User> users, long lastUserIndexChangeTimestamp) {
        users.forEach(this::addUser);
        this.lastUserIndexChangeTimestamp = lastUserIndexChangeTimestamp;
    }

    public static synchronized UserAliasLookup createInstance(GlobalStorageSystem globalStorageSystem) throws StorageException {
        UserIndex userIndex = (UserIndex)globalStorageSystem.openGlobalIndex(UserIndex.class);
        long lastChangeTimestamp = userIndex.getLastChangeTimestamp();
        if (instanceWithLastChangeTimestamp == null || lastChangeTimestamp > UserAliasLookup.instanceWithLastChangeTimestamp.lastUserIndexChangeTimestamp) {
            instanceWithLastChangeTimestamp = new UserAliasLookup(userIndex.getAllUsers(), lastChangeTimestamp);
        }
        return instanceWithLastChangeTimestamp;
    }

    public Optional<User> resolveAuthorOf(IRepositoryLogEntry repositoryLogEntry) {
        return this.resolveUser(repositoryLogEntry.getEmail()).or(() -> this.resolveUser(repositoryLogEntry.getAuthor()));
    }

    public Optional<User> resolveUser(@Nullable String value) {
        if (value == null) {
            return Optional.empty();
        }
        return this.resolveUserUnsanitized(value).map(UserAliasLookup::sanitizeAuthenticatorAndGetUser);
    }

    private Optional<User> resolveUserUnsanitized(String value) {
        Optional<User> user = this.resolveAliasToUser(value);
        if (user.isPresent()) {
            return user;
        }
        String normalizedAliasUsernameOrFullname = UserAliasLookup.normalizeUsername(value);
        if (this.fullNameLookup.containsKey(normalizedAliasUsernameOrFullname)) {
            return Optional.of(this.fullNameLookup.get(normalizedAliasUsernameOrFullname));
        }
        if (this.eMailLookup.containsKey(normalizedAliasUsernameOrFullname)) {
            return Optional.of(this.eMailLookup.get(normalizedAliasUsernameOrFullname));
        }
        return this.resolveUserFullnameWithSuffix(normalizedAliasUsernameOrFullname);
    }

    private static User sanitizeAuthenticatorAndGetUser(User user) {
        user.setAuthenticator(AuthenticationManager.getInstance().sanitizeAuthenticator(user.getAuthenticator()));
        return user;
    }

    @VisibleForTesting
    public static Long getCacheTimestamp() {
        if (instanceWithLastChangeTimestamp == null) {
            return null;
        }
        return UserAliasLookup.instanceWithLastChangeTimestamp.lastUserIndexChangeTimestamp;
    }

    private Optional<User> resolveUserFullnameWithSuffix(String normalizedAliasUsernameOrFullname) {
        User lookedUpUser;
        Pair searchNameAndSuffix = UserAliasLookup.identifySuffix(normalizedAliasUsernameOrFullname);
        String currentSearchName = (String)searchNameAndSuffix.getFirst();
        StringBuilder currentSuffix = new StringBuilder((String)searchNameAndSuffix.getSecond());
        if (KNOWN_SUFFIXES.contains(currentSuffix.toString()) && (lookedUpUser = this.fullNameLookup.get(currentSearchName)) != null) {
            return Optional.of(this.fullNameLookup.get(currentSearchName));
        }
        while (!((String)searchNameAndSuffix.getSecond()).isEmpty()) {
            if (this.fullNameLookup.containsKey(currentSearchName)) {
                KNOWN_SUFFIXES.add(currentSuffix.toString());
                return Optional.of(this.fullNameLookup.get(currentSearchName));
            }
            searchNameAndSuffix = StringUtils.splitAtLast((String)currentSearchName, (char)' ');
            currentSearchName = (String)searchNameAndSuffix.getFirst();
            currentSuffix.insert(0, (String)searchNameAndSuffix.getSecond() + " ");
        }
        return Optional.empty();
    }

    private static Pair<String, String> identifySuffix(String normalizedAliasUsernameOrFullname) {
        for (String knownSuffix : KNOWN_SUFFIXES) {
            if (!normalizedAliasUsernameOrFullname.endsWith(knownSuffix)) continue;
            return new Pair((Object)normalizedAliasUsernameOrFullname.replace(knownSuffix, "").trim(), (Object)knownSuffix);
        }
        return StringUtils.splitAtLast((String)normalizedAliasUsernameOrFullname, (char)' ');
    }

    private Optional<User> resolveAliasToUser(String aliasOrUsername) {
        String normalizedAlias = UserAliasLookup.normalizeUsername(aliasOrUsername);
        if (this.allUsers.containsKey(normalizedAlias)) {
            return Optional.ofNullable(this.allUsers.get(normalizedAlias));
        }
        if (this.aliasLookup.containsKey(normalizedAlias)) {
            return Optional.ofNullable(this.aliasLookup.get(normalizedAlias));
        }
        int indexOfBackslash = aliasOrUsername.indexOf(92);
        if (indexOfBackslash != -1) {
            aliasOrUsername = aliasOrUsername.substring(indexOfBackslash + 1);
            return this.resolveAliasToUser(aliasOrUsername);
        }
        return Optional.empty();
    }

    private static String normalizeUsername(String username) {
        return username.toLowerCase();
    }

    private void addUser(User user) {
        this.allUsers.put(UserAliasLookup.normalizeUsername(user.getUsername()), user);
        this.addUserFullNameToLookup(user);
        String eMail = user.getEmailAddress();
        if (!StringUtils.isEmpty((String)eMail)) {
            this.eMailLookup.put(UserAliasLookup.normalizeUsername(eMail), user);
        }
        for (String userAlias : user.getAliases()) {
            this.aliasLookup.put(UserAliasLookup.normalizeUsername(userAlias), user);
        }
    }

    private void addUserFullNameToLookup(User user) {
        for (String validDelimiter : VALID_DELIMITERS) {
            this.fullNameLookup.put(UserAliasLookup.getNormalizedFullName(user, validDelimiter), user);
            this.fullNameLookup.put(UserAliasLookup.getNormalizedFullNameReverse(user, validDelimiter), user);
        }
    }

    private static String getNormalizedFullName(User user, String delimiter) {
        return UserAliasLookup.normalizeUsername(user.getFirstName() + delimiter + user.getLastName());
    }

    private static String getNormalizedFullNameReverse(User user, String delimiter) {
        return UserAliasLookup.normalizeUsername(user.getLastName() + delimiter + user.getFirstName());
    }
}

