/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.markdown;

import org.sonar.channel.ChannelDispatcher;
import org.sonar.channel.CodeReader;
import org.sonar.markdown.BlackholeChannel;
import org.sonar.markdown.HtmlBlockquoteChannel;
import org.sonar.markdown.HtmlCodeChannel;
import org.sonar.markdown.HtmlEmphasisChannel;
import org.sonar.markdown.HtmlEndOfLineChannel;
import org.sonar.markdown.HtmlHeadingChannel;
import org.sonar.markdown.HtmlLinkChannel;
import org.sonar.markdown.HtmlListChannel;
import org.sonar.markdown.HtmlMultilineCodeChannel;
import org.sonar.markdown.HtmlUrlChannel;
import org.sonar.markdown.IdentifierAndNumberChannel;
import org.sonar.markdown.MarkdownOutput;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang.StringEscapeUtils;

public final class Markdown {
    private ChannelDispatcher<MarkdownOutput> dispatcher = ChannelDispatcher.builder().addChannel(new HtmlLinkChannel()).addChannel(new HtmlUrlChannel()).addChannel(new HtmlEndOfLineChannel()).addChannel(new HtmlEmphasisChannel()).addChannel(new HtmlListChannel()).addChannel(new HtmlBlockquoteChannel()).addChannel(new HtmlHeadingChannel()).addChannel(new HtmlCodeChannel()).addChannel(new HtmlMultilineCodeChannel()).addChannel(new IdentifierAndNumberChannel()).addChannel(new BlackholeChannel()).build();

    private Markdown() {
    }

    private String convert(String input) {
        CodeReader reader = new CodeReader(input);
        MarkdownOutput output = new MarkdownOutput();
        this.dispatcher.consume(reader, output);
        return output.toString();
    }

    public static String convertToHtml(String input) {
        return new Markdown().convert(StringEscapeUtils.escapeHtml(input));
    }
}

