/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.scan.filesystem.FileExclusions;
import org.sonarsource.sonarlint.core.analysis.container.analysis.SonarLintPathPattern;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.ArrayUtils;

public class ServerFileExclusions {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final FileExclusions exclusionSettings;
    private SonarLintPathPattern[] mainInclusions;
    private SonarLintPathPattern[] mainExclusions;
    private SonarLintPathPattern[] testInclusions;
    private SonarLintPathPattern[] testExclusions;

    public ServerFileExclusions(Configuration configuration) {
        this.exclusionSettings = new FileExclusions(configuration);
    }

    public void prepare() {
        this.mainInclusions = this.prepareMainInclusions();
        this.mainExclusions = this.prepareMainExclusions();
        this.testInclusions = this.prepareTestInclusions();
        this.testExclusions = this.prepareTestExclusions();
        ServerFileExclusions.log("Server included sources: ", this.mainInclusions);
        ServerFileExclusions.log("Server excluded sources: ", this.mainExclusions);
        ServerFileExclusions.log("Server included tests: ", this.testInclusions);
        ServerFileExclusions.log("Server excluded tests: ", this.testExclusions);
    }

    private static void log(String title, SonarLintPathPattern[] patterns) {
        if (patterns.length > 0) {
            LOG.debug(title);
            for (SonarLintPathPattern pattern : patterns) {
                LOG.debug("  {}", (Object)pattern);
            }
        }
    }

    public boolean accept(String relativePath, InputFile.Type type) {
        SonarLintPathPattern[] exclusionPatterns;
        SonarLintPathPattern[] inclusionPatterns;
        if (InputFile.Type.MAIN == type) {
            inclusionPatterns = this.mainInclusions;
            exclusionPatterns = this.mainExclusions;
        } else if (InputFile.Type.TEST == type) {
            inclusionPatterns = this.testInclusions;
            exclusionPatterns = this.testExclusions;
        } else {
            throw new IllegalArgumentException("Unknown file type: " + type);
        }
        if (inclusionPatterns.length > 0) {
            boolean matchInclusion = false;
            SonarLintPathPattern[] sonarLintPathPatternArray = inclusionPatterns;
            int n = sonarLintPathPatternArray.length;
            for (int i = 0; i < n; ++i) {
                SonarLintPathPattern pattern = sonarLintPathPatternArray[i];
                matchInclusion |= pattern.match(relativePath);
            }
            if (!matchInclusion) {
                return false;
            }
        }
        if (exclusionPatterns.length > 0) {
            for (SonarLintPathPattern pattern : exclusionPatterns) {
                if (!pattern.match(relativePath)) continue;
                return false;
            }
        }
        return true;
    }

    SonarLintPathPattern[] prepareMainInclusions() {
        if (this.exclusionSettings.sourceInclusions().length > 0) {
            return SonarLintPathPattern.create(this.exclusionSettings.sourceInclusions());
        }
        return new SonarLintPathPattern[0];
    }

    SonarLintPathPattern[] prepareTestInclusions() {
        return SonarLintPathPattern.create(this.computeTestInclusions());
    }

    private String[] computeTestInclusions() {
        if (this.exclusionSettings.testInclusions().length > 0) {
            return this.exclusionSettings.testInclusions();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    SonarLintPathPattern[] prepareMainExclusions() {
        String[] patterns = ArrayUtils.addAll(this.exclusionSettings.sourceExclusions(), this.computeTestInclusions());
        return SonarLintPathPattern.create(patterns);
    }

    SonarLintPathPattern[] prepareTestExclusions() {
        return SonarLintPathPattern.create(this.exclusionSettings.testExclusions());
    }
}

