/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisEngineConfiguration;
import org.sonarsource.sonarlint.core.analysis.command.Command;
import org.sonarsource.sonarlint.core.analysis.container.global.GlobalAnalysisContainer;
import org.sonarsource.sonarlint.core.analysis.container.global.ModuleRegistry;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.plugin.commons.LoadedPlugins;

public class AnalysisEngine {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final Runnable CANCELING_TERMINATION = () -> {};
    private final GlobalAnalysisContainer globalAnalysisContainer;
    private final BlockingQueue<AsyncCommand<?>> commandQueue = new LinkedBlockingQueue();
    private final Thread analysisThread = new Thread(this::executeQueuedCommands, "sonarlint-analysis-engine");
    private final ClientLogOutput logOutput;
    private final AtomicReference<Runnable> termination = new AtomicReference();
    private final AtomicReference<AsyncCommand<?>> executingCommand = new AtomicReference();

    public AnalysisEngine(AnalysisEngineConfiguration analysisGlobalConfig, LoadedPlugins loadedPlugins, @Nullable ClientLogOutput logOutput) {
        this.globalAnalysisContainer = new GlobalAnalysisContainer(analysisGlobalConfig, loadedPlugins);
        this.logOutput = logOutput;
        this.start();
    }

    private void start() {
        this.globalAnalysisContainer.startComponents();
        this.analysisThread.start();
    }

    private void executeQueuedCommands() {
        while (this.termination.get() == null) {
            SonarLintLogger.setTarget(this.logOutput);
            try {
                this.executingCommand.set(this.commandQueue.take());
                if (this.termination.get() == CANCELING_TERMINATION) {
                    this.executingCommand.get().cancel();
                    break;
                }
                this.executingCommand.get().execute(this.getModuleRegistry());
                this.executingCommand.set(null);
            }
            catch (InterruptedException e) {
                if (this.termination.get() == CANCELING_TERMINATION) continue;
                LOG.error("Analysis engine interrupted", e);
            }
        }
        this.termination.get().run();
    }

    public <T> CompletableFuture<T> post(Command<T> command, ProgressMonitor progressMonitor) {
        if (this.termination.get() != null) {
            LOG.error("Analysis engine stopping, ignoring command");
            return CompletableFuture.completedFuture(null);
        }
        if (!this.analysisThread.isAlive()) {
            LOG.error("Analysis engine not started, ignoring command");
            return CompletableFuture.completedFuture(null);
        }
        AsyncCommand<T> asyncCommand = new AsyncCommand<T>(command, progressMonitor);
        try {
            this.commandQueue.put(asyncCommand);
        }
        catch (InterruptedException e) {
            asyncCommand.future.completeExceptionally(e);
        }
        return asyncCommand.future;
    }

    public void finishGracefully() {
        this.termination.compareAndSet(null, this::honorPendingCommands);
    }

    private void honorPendingCommands() {
        ArrayList pendingCommands = new ArrayList();
        this.commandQueue.drainTo(pendingCommands);
        pendingCommands.forEach(c -> c.execute(this.getModuleRegistry()));
        this.globalAnalysisContainer.stopComponents();
    }

    public void stop() {
        if (!this.analysisThread.isAlive()) {
            return;
        }
        if (!this.termination.compareAndSet(null, CANCELING_TERMINATION)) {
            return;
        }
        AsyncCommand<?> command = this.executingCommand.get();
        if (command != null) {
            command.cancel();
        }
        this.analysisThread.interrupt();
        ArrayList pendingCommands = new ArrayList();
        this.commandQueue.drainTo(pendingCommands);
        pendingCommands.forEach(c -> c.future.cancel(false));
        this.globalAnalysisContainer.stopComponents();
    }

    public ModuleRegistry getModuleRegistry() {
        return this.globalAnalysisContainer.getModuleRegistry();
    }

    public GlobalAnalysisContainer getGlobalAnalysisContainer() {
        return this.globalAnalysisContainer;
    }

    public static class AsyncCommand<T> {
        private final CompletableFuture<T> future = new CompletableFuture();
        private final Command<T> command;
        private final ProgressMonitor progressMonitor;

        public AsyncCommand(Command<T> command, ProgressMonitor progressMonitor) {
            this.command = command;
            this.progressMonitor = progressMonitor;
        }

        public void execute(ModuleRegistry moduleRegistry) {
            try {
                T result = this.command.execute(moduleRegistry, this.progressMonitor);
                this.future.complete(result);
            }
            catch (Throwable e) {
                this.future.completeExceptionally(e);
            }
        }

        public void cancel() {
            this.progressMonitor.cancel();
        }
    }
}

