/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.config.Configuration;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern.IssuePattern;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public abstract class AbstractPatternInitializer {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Configuration config;
    private List<IssuePattern> multicriteriaPatterns;

    protected AbstractPatternInitializer(Configuration config) {
        this.config = config;
        this.initPatterns();
    }

    protected Configuration getSettings() {
        return this.config;
    }

    public List<IssuePattern> getMulticriteriaPatterns() {
        return this.multicriteriaPatterns;
    }

    public boolean hasConfiguredPatterns() {
        return this.hasMulticriteriaPatterns();
    }

    public boolean hasMulticriteriaPatterns() {
        return !this.multicriteriaPatterns.isEmpty();
    }

    protected final void initPatterns() {
        this.multicriteriaPatterns = new ArrayList<IssuePattern>();
        for (String id : this.config.getStringArray(this.getMulticriteriaConfigurationKey())) {
            String propPrefix = this.getMulticriteriaConfigurationKey() + "." + id + ".";
            String filePathPattern = this.config.get(propPrefix + "resourceKey").orElse(null);
            if (StringUtils.isBlank(filePathPattern)) {
                LOG.debug("Issue exclusions are misconfigured. File pattern is mandatory for each entry of '" + this.getMulticriteriaConfigurationKey() + "'");
                continue;
            }
            String ruleKeyPattern = this.config.get(propPrefix + "ruleKey").orElse(null);
            if (StringUtils.isBlank(ruleKeyPattern)) {
                LOG.debug("Issue exclusions are misconfigured. Rule key pattern is mandatory for each entry of '" + this.getMulticriteriaConfigurationKey() + "'");
                continue;
            }
            IssuePattern pattern = new IssuePattern(filePathPattern, ruleKeyPattern);
            this.multicriteriaPatterns.add(pattern);
        }
    }

    protected abstract String getMulticriteriaConfigurationKey();
}

