/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.global;

import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.analysis.api.ClientModuleFileSystem;
import org.sonarsource.sonarlint.core.analysis.api.ClientModuleInfo;
import org.sonarsource.sonarlint.core.analysis.api.ClientModulesProvider;
import org.sonarsource.sonarlint.core.analysis.container.global.TransientModuleFileSystem;
import org.sonarsource.sonarlint.core.analysis.container.module.ModuleContainer;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.plugin.commons.container.SpringComponentContainer;

public class ModuleRegistry {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ConcurrentHashMap<Object, ModuleContainer> moduleContainersByKey = new ConcurrentHashMap();
    private final SpringComponentContainer parent;

    public ModuleRegistry(SpringComponentContainer parent, @Nullable ClientModulesProvider modulesProvider) {
        this.parent = parent;
        if (modulesProvider != null) {
            modulesProvider.getModules().forEach(this::registerModule);
        }
    }

    public ModuleContainer registerModule(ClientModuleInfo moduleInfo) {
        return this.moduleContainersByKey.computeIfAbsent(moduleInfo.key(), id -> this.createContainer(id, moduleInfo.fileSystem()));
    }

    private ModuleContainer createContainer(Object moduleKey, @Nullable ClientModuleFileSystem clientFileSystem) {
        LOG.debug("Creating container for module '" + moduleKey + "'");
        ModuleContainer moduleContainer = new ModuleContainer(this.parent, false);
        if (clientFileSystem != null) {
            moduleContainer.add(clientFileSystem);
        }
        moduleContainer.startComponents();
        return moduleContainer;
    }

    public ModuleContainer createTransientContainer(Iterable<ClientInputFile> filesToAnalyze) {
        LOG.debug("Creating transient module container");
        ModuleContainer moduleContainer = new ModuleContainer(this.parent, true);
        moduleContainer.add(new TransientModuleFileSystem(filesToAnalyze));
        moduleContainer.startComponents();
        return moduleContainer;
    }

    public void unregisterModule(Object moduleKey) {
        if (!this.moduleContainersByKey.containsKey(moduleKey)) {
            return;
        }
        ModuleContainer moduleContainer = this.moduleContainersByKey.remove(moduleKey);
        moduleContainer.stopComponents();
    }

    public void stopAll() {
        this.moduleContainersByKey.values().forEach(SpringComponentContainer::stopComponents);
        this.moduleContainersByKey.clear();
    }

    @CheckForNull
    public ModuleContainer getContainerFor(Object moduleKey) {
        return this.moduleContainersByKey.get(moduleKey);
    }
}

