/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.common.analysis;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.analysis.api.Flow;
import org.sonarsource.sonarlint.core.analysis.api.QuickFix;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;
import org.sonarsource.sonarlint.core.commons.TextRange;
import org.sonarsource.sonarlint.core.commons.VulnerabilityProbability;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDefinition;

public final class DefaultClientIssue
implements Issue {
    private final IssueSeverity severity;
    private final RuleType type;
    private final CleanCodeAttribute cleanCodeAttribute;
    private final Map<SoftwareQuality, ImpactSeverity> impacts;
    private final String ruleKey;
    private final String primaryMessage;
    private final ClientInputFile clientInputFile;
    private final List<Flow> flows;
    private final List<QuickFix> quickFixes;
    private final TextRange textRange;
    private final Optional<String> ruleDescriptionContextKey;
    private final Optional<VulnerabilityProbability> vulnerabilityProbability;

    public DefaultClientIssue(org.sonarsource.sonarlint.core.analysis.api.Issue i, SonarLintRuleDefinition sonarLintRuleDefinition) {
        this.textRange = i.getTextRange() != null ? i.getTextRange() : null;
        this.primaryMessage = i.getMessage();
        this.clientInputFile = i.getInputFile();
        this.flows = i.flows();
        this.quickFixes = i.quickFixes();
        this.ruleDescriptionContextKey = i.getRuleDescriptionContextKey();
        this.severity = sonarLintRuleDefinition.getDefaultSeverity();
        this.type = sonarLintRuleDefinition.getType();
        this.cleanCodeAttribute = sonarLintRuleDefinition.getCleanCodeAttribute().orElse(CleanCodeAttribute.defaultCleanCodeAttribute());
        this.impacts = new EnumMap<SoftwareQuality, ImpactSeverity>(SoftwareQuality.class);
        this.impacts.putAll(sonarLintRuleDefinition.getDefaultImpacts());
        this.impacts.putAll(i.getOverriddenImpacts());
        this.ruleKey = sonarLintRuleDefinition.getKey();
        this.vulnerabilityProbability = sonarLintRuleDefinition.getVulnerabilityProbability();
    }

    public DefaultClientIssue(org.sonarsource.sonarlint.core.analysis.api.Issue i, IssueSeverity severity, RuleType type, @Nullable CleanCodeAttribute cleanCodeAttribute, Map<SoftwareQuality, ImpactSeverity> defaultImpacts, Optional<VulnerabilityProbability> vulnerabilityProbability) {
        this.textRange = i.getTextRange() != null ? i.getTextRange() : null;
        this.primaryMessage = i.getMessage();
        this.clientInputFile = i.getInputFile();
        this.flows = i.flows();
        this.quickFixes = i.quickFixes();
        this.severity = severity;
        this.type = type;
        this.cleanCodeAttribute = cleanCodeAttribute;
        this.impacts = new EnumMap<SoftwareQuality, ImpactSeverity>(SoftwareQuality.class);
        if (!defaultImpacts.isEmpty()) {
            this.impacts.putAll(defaultImpacts);
            this.impacts.putAll(i.getOverriddenImpacts());
        }
        this.ruleKey = i.getRuleKey();
        this.ruleDescriptionContextKey = i.getRuleDescriptionContextKey();
        this.vulnerabilityProbability = vulnerabilityProbability;
    }

    @Override
    public IssueSeverity getSeverity() {
        return this.severity;
    }

    @Override
    public RuleType getType() {
        return this.type;
    }

    @Override
    public Optional<CleanCodeAttribute> getCleanCodeAttribute() {
        return Optional.ofNullable(this.cleanCodeAttribute);
    }

    @Override
    public Map<SoftwareQuality, ImpactSeverity> getImpacts() {
        return this.impacts;
    }

    @Override
    public String getRuleKey() {
        return this.ruleKey;
    }

    @Override
    public String getMessage() {
        return this.primaryMessage;
    }

    @Override
    @CheckForNull
    public ClientInputFile getInputFile() {
        return this.clientInputFile;
    }

    @Override
    public List<Flow> flows() {
        return this.flows;
    }

    @Override
    public List<QuickFix> quickFixes() {
        return this.quickFixes;
    }

    @Override
    public Optional<String> getRuleDescriptionContextKey() {
        return this.ruleDescriptionContextKey;
    }

    @Override
    public Optional<VulnerabilityProbability> getVulnerabilityProbability() {
        return this.vulnerabilityProbability;
    }

    @Override
    @CheckForNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("rule=").append(this.ruleKey);
        sb.append(", severity=").append((Object)this.severity);
        Integer startLine = this.getStartLine();
        if (startLine != null) {
            sb.append(", line=").append(startLine);
        }
        if (this.clientInputFile != null) {
            sb.append(", file=").append(this.clientInputFile.uri());
        }
        sb.append("]");
        return sb.toString();
    }
}

