/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.standalone;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleParam;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleKey;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDefinition;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleParamDefinition;

public class StandaloneRuleDetails
implements RuleDetails {
    private final RuleKey key;
    private final String name;
    private final IssueSeverity severity;
    private final RuleType type;
    private final String description;
    private final Map<String, StandaloneRuleParam> params;
    private final boolean isActiveByDefault;
    private final Language language;
    private final String[] tags;
    private final Set<RuleKey> deprecatedKeys;

    public StandaloneRuleDetails(SonarLintRuleDefinition ruleFromDefinition) {
        RuleKey sonarApiRuleKey;
        this.key = sonarApiRuleKey = RuleKey.parse(ruleFromDefinition.getKey());
        this.name = ruleFromDefinition.getName();
        this.severity = ruleFromDefinition.getDefaultSeverity();
        this.type = ruleFromDefinition.getType();
        this.description = ruleFromDefinition.getHtmlDescription();
        this.isActiveByDefault = ruleFromDefinition.isActiveByDefault();
        this.language = ruleFromDefinition.getLanguage();
        this.tags = ruleFromDefinition.getTags();
        this.deprecatedKeys = ruleFromDefinition.getDeprecatedKeys().stream().map(RuleKey::parse).collect(Collectors.toSet());
        HashMap<String, StandaloneRuleParam> builder = new HashMap<String, StandaloneRuleParam>();
        for (SonarLintRuleParamDefinition param : ruleFromDefinition.getParams().values()) {
            builder.put(param.key(), new StandaloneRuleParam(param));
        }
        this.params = Collections.unmodifiableMap(builder);
    }

    public Collection<StandaloneRuleParam> paramDetails() {
        return this.params.values();
    }

    public boolean isActiveByDefault() {
        return this.isActiveByDefault;
    }

    @Override
    public String getKey() {
        return this.key.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHtmlDescription() {
        return this.description;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public IssueSeverity getDefaultSeverity() {
        return this.severity;
    }

    @Override
    public RuleType getType() {
        return this.type;
    }

    public String[] getTags() {
        return this.tags;
    }

    public Set<RuleKey> getDeprecatedKeys() {
        return this.deprecatedKeys;
    }
}

