/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.local.only;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStores;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.util.CompressBackupUtil;
import org.sonarsource.sonarlint.core.commons.IssueStatus;
import org.sonarsource.sonarlint.core.commons.LineWithHash;
import org.sonarsource.sonarlint.core.commons.LocalOnlyIssue;
import org.sonarsource.sonarlint.core.commons.LocalOnlyIssueResolution;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.local.only.IssueStatusBinding;
import org.sonarsource.sonarlint.core.local.only.UuidBinding;
import org.sonarsource.sonarlint.core.serverconnection.storage.InstantBinding;
import org.sonarsource.sonarlint.core.serverconnection.storage.TarGzUtils;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.FileUtils;

public class XodusLocalOnlyIssueStore {
    private static final String CONFIGURATION_SCOPE_ID_ENTITY_TYPE = "Scope";
    private static final String CONFIGURATION_SCOPE_ID_TO_FILES_LINK_NAME = "files";
    private static final String FILE_ENTITY_TYPE = "File";
    private static final String PATH_PROPERTY_NAME = "path";
    private static final String NAME_PROPERTY_NAME = "name";
    private static final String ISSUE_ENTITY_TYPE = "Issue";
    private static final String FILE_TO_ISSUES_LINK_NAME = "issues";
    private static final String UUID_PROPERTY_NAME = "uuid";
    private static final String ISSUE_TO_FILE_LINK_NAME = "file";
    private static final String COMMENT_PROPERTY_NAME = "comment";
    private static final String RESOLVED_STATUS_PROPERTY_NAME = "resolvedStatus";
    private static final String RESOLUTION_DATE_PROPERTY_NAME = "resolvedDate";
    private static final String RULE_KEY_PROPERTY_NAME = "ruleKey";
    private static final String RANGE_HASH_PROPERTY_NAME = "rangeHash";
    private static final String LINE_HASH_PROPERTY_NAME = "lineHash";
    private static final String START_LINE_PROPERTY_NAME = "startLine";
    private static final String START_LINE_OFFSET_PROPERTY_NAME = "startLineOffset";
    private static final String END_LINE_PROPERTY_NAME = "endLine";
    private static final String END_LINE_OFFSET_PROPERTY_NAME = "endLineOffset";
    private static final String MESSAGE_BLOB_NAME = "message";
    private static final String BACKUP_TAR_GZ = "local_only_issue_backup.tar.gz";
    private final PersistentEntityStore entityStore;
    private final Path backupFile;
    private final Path xodusDbDir;
    private static final SonarLintLogger LOG = SonarLintLogger.get();

    public XodusLocalOnlyIssueStore(Path backupDir, Path workDir) throws IOException {
        this.xodusDbDir = Files.createTempDirectory(workDir, "xodus-local-only-issue-store", new FileAttribute[0]);
        this.backupFile = backupDir.resolve(BACKUP_TAR_GZ);
        if (Files.isRegularFile(this.backupFile, new LinkOption[0])) {
            LOG.debug("Restoring previous local-only issue database from {}", (Object)this.backupFile);
            try {
                TarGzUtils.extractTarGz(this.backupFile, this.xodusDbDir);
            }
            catch (Exception e) {
                LOG.error("Unable to restore local-only issue backup {}", (Object)this.backupFile);
            }
        }
        LOG.debug("Starting local-only issue database from {}", (Object)this.xodusDbDir);
        this.entityStore = this.buildEntityStore();
        this.entityStore.executeInTransaction(txn -> {
            this.entityStore.registerCustomPropertyType(txn, Instant.class, (ComparableBinding)new InstantBinding());
            this.entityStore.registerCustomPropertyType(txn, UUID.class, (ComparableBinding)new UuidBinding());
            this.entityStore.registerCustomPropertyType(txn, IssueStatus.class, (ComparableBinding)new IssueStatusBinding());
        });
    }

    public List<LocalOnlyIssue> loadForFile(String configurationScopeId, String filePath) {
        return (List)this.entityStore.computeInReadonlyTransaction(txn -> XodusLocalOnlyIssueStore.findUnique(txn, CONFIGURATION_SCOPE_ID_ENTITY_TYPE, NAME_PROPERTY_NAME, configurationScopeId).map(configScopeId -> configScopeId.getLinks(CONFIGURATION_SCOPE_ID_TO_FILES_LINK_NAME)).flatMap(files -> XodusLocalOnlyIssueStore.findUniqueAmong(files, PATH_PROPERTY_NAME, filePath)).map(fileToLoad -> fileToLoad.getLinks(FILE_TO_ISSUES_LINK_NAME)).map(issueEntities -> StreamSupport.stream(issueEntities.spliterator(), false).map(XodusLocalOnlyIssueStore::adapt).collect(Collectors.toList())).orElseGet(Collections::emptyList));
    }

    public List<LocalOnlyIssue> loadAll(String configurationScopeId) {
        return (List)this.entityStore.computeInReadonlyTransaction(txn -> XodusLocalOnlyIssueStore.findUnique(txn, CONFIGURATION_SCOPE_ID_ENTITY_TYPE, NAME_PROPERTY_NAME, configurationScopeId).map(configScopeId -> configScopeId.getLinks(CONFIGURATION_SCOPE_ID_TO_FILES_LINK_NAME)).flatMap(filesIterable -> {
            ArrayList allIssues = new ArrayList();
            List<Entity> files = StreamSupport.stream(filesIterable.spliterator(), false).collect(Collectors.toList());
            files.forEach(file -> {
                EntityIterable issueEntitiesForFile = file.getLinks(FILE_TO_ISSUES_LINK_NAME);
                List localIssuesForFile = StreamSupport.stream(issueEntitiesForFile.spliterator(), false).map(XodusLocalOnlyIssueStore::adapt).collect(Collectors.toList());
                allIssues.addAll(localIssuesForFile);
            });
            return Optional.of(allIssues);
        }).orElseGet(Collections::emptyList));
    }

    public void storeLocalOnlyIssue(String configurationScopeId, LocalOnlyIssue issue) {
        this.entityStore.computeInTransaction(txn -> {
            Entity configurationScope = XodusLocalOnlyIssueStore.getOrCreateConfigurationScopeId(configurationScopeId, txn);
            Entity fileEntity = XodusLocalOnlyIssueStore.getOrCreateFile(configurationScope, issue.getServerRelativePath(), txn);
            XodusLocalOnlyIssueStore.updateOrCreateIssue(fileEntity, issue, txn);
            return true;
        });
    }

    public boolean removeIssue(UUID issueId) {
        return (Boolean)this.entityStore.computeInTransaction(txn -> {
            EntityIterable entities = txn.find(ISSUE_ENTITY_TYPE, UUID_PROPERTY_NAME, (Comparable)issueId);
            Entity entity = entities.getFirst();
            if (entity != null) {
                Entity link = entity.getLink(ISSUE_TO_FILE_LINK_NAME);
                if (link != null) {
                    link.deleteLink(FILE_TO_ISSUES_LINK_NAME, entity);
                }
                return entity.delete();
            }
            return false;
        });
    }

    public boolean removeAllIssuesForFile(String configurationScopeId, String filePath) {
        return (Boolean)this.entityStore.computeInTransaction(txn -> {
            Entity configurationScope = XodusLocalOnlyIssueStore.getOrCreateConfigurationScopeId(configurationScopeId, txn);
            Entity fileEntity = XodusLocalOnlyIssueStore.getOrCreateFile(configurationScope, filePath, txn);
            fileEntity.getLinks(FILE_TO_ISSUES_LINK_NAME).forEach(Entity::delete);
            return fileEntity.delete();
        });
    }

    private static LocalOnlyIssue adapt(Entity storedIssue) {
        String filePath = (String)((Object)Objects.requireNonNull(storedIssue.getLink(ISSUE_TO_FILE_LINK_NAME).getProperty(PATH_PROPERTY_NAME)));
        UUID uuid = (UUID)Objects.requireNonNull(storedIssue.getProperty(UUID_PROPERTY_NAME));
        IssueStatus status = (IssueStatus)((Object)Objects.requireNonNull(storedIssue.getProperty(RESOLVED_STATUS_PROPERTY_NAME)));
        Instant resolvedDate = (Instant)Objects.requireNonNull(storedIssue.getProperty(RESOLUTION_DATE_PROPERTY_NAME));
        String ruleKey = (String)((Object)Objects.requireNonNull(storedIssue.getProperty(RULE_KEY_PROPERTY_NAME)));
        String msg = Objects.requireNonNull(storedIssue.getBlobString(MESSAGE_BLOB_NAME));
        String comment = storedIssue.getBlobString(COMMENT_PROPERTY_NAME);
        Integer startLine = (Integer)storedIssue.getProperty(START_LINE_PROPERTY_NAME);
        TextRangeWithHash textRange = null;
        LineWithHash lineWithHash = null;
        if (startLine != null) {
            String lineHash;
            String rangeHash = (String)((Object)storedIssue.getProperty(RANGE_HASH_PROPERTY_NAME));
            if (rangeHash != null) {
                Integer startLineOffset = (Integer)storedIssue.getProperty(START_LINE_OFFSET_PROPERTY_NAME);
                Integer endLine = (Integer)storedIssue.getProperty(END_LINE_PROPERTY_NAME);
                Integer endLineOffset = (Integer)storedIssue.getProperty(END_LINE_OFFSET_PROPERTY_NAME);
                textRange = new TextRangeWithHash(startLine, startLineOffset, endLine, endLineOffset, rangeHash);
            }
            if ((lineHash = (String)((Object)storedIssue.getProperty(LINE_HASH_PROPERTY_NAME))) != null) {
                lineWithHash = new LineWithHash(startLine, lineHash);
            }
        }
        return new LocalOnlyIssue(uuid, filePath, textRange, lineWithHash, ruleKey, msg, new LocalOnlyIssueResolution(status, resolvedDate, comment));
    }

    private PersistentEntityStore buildEntityStore() {
        Environment environment = Environments.newInstance((File)this.xodusDbDir.toAbsolutePath().toFile(), (EnvironmentConfig)new EnvironmentConfig().setLogAllowRemote(true).setLogAllowRemovable(true).setLogAllowRamDisk(true));
        PersistentEntityStoreImpl entityStoreImpl = PersistentEntityStores.newInstance((Environment)environment);
        entityStoreImpl.setCloseEnvironment(true);
        return entityStoreImpl;
    }

    private static Optional<Entity> findUnique(StoreTransaction transaction, String entityType, String propertyName, Comparable<?> caseSensitivePropertyValue) {
        EntityIterable entities = transaction.find(entityType, propertyName, caseSensitivePropertyValue);
        return XodusLocalOnlyIssueStore.findUniqueAmong(entities, propertyName, caseSensitivePropertyValue);
    }

    private static Optional<Entity> findUniqueAmong(EntityIterable iterable, String propertyName, Comparable<?> caseSensitivePropertyValue) {
        return StreamSupport.stream(iterable.spliterator(), false).filter(e -> caseSensitivePropertyValue.equals(e.getProperty(propertyName))).findFirst();
    }

    private static Entity getOrCreateConfigurationScopeId(String configurationScopeId, StoreTransaction txn) {
        return XodusLocalOnlyIssueStore.findUnique(txn, CONFIGURATION_SCOPE_ID_ENTITY_TYPE, NAME_PROPERTY_NAME, configurationScopeId).orElseGet(() -> {
            Entity configurationScope = txn.newEntity(CONFIGURATION_SCOPE_ID_ENTITY_TYPE);
            configurationScope.setProperty(NAME_PROPERTY_NAME, (Comparable)((Object)configurationScopeId));
            return configurationScope;
        });
    }

    private static Entity getOrCreateFile(Entity moduleEntity, String filePath, StoreTransaction txn) {
        return XodusLocalOnlyIssueStore.findUniqueAmong(moduleEntity.getLinks(CONFIGURATION_SCOPE_ID_TO_FILES_LINK_NAME), PATH_PROPERTY_NAME, filePath).orElseGet(() -> {
            Entity file = txn.newEntity(FILE_ENTITY_TYPE);
            file.setProperty(PATH_PROPERTY_NAME, (Comparable)((Object)filePath));
            moduleEntity.addLink(CONFIGURATION_SCOPE_ID_TO_FILES_LINK_NAME, file);
            return file;
        });
    }

    private static void updateOrCreateIssue(Entity fileEntity, LocalOnlyIssue issue, StoreTransaction transaction) {
        Entity issueEntity = XodusLocalOnlyIssueStore.updateOrCreateIssueCommon(fileEntity, issue.getId(), transaction);
        XodusLocalOnlyIssueStore.updateIssueEntity(issueEntity, issue);
    }

    private static Entity updateOrCreateIssueCommon(Entity fileEntity, UUID issueUuid, StoreTransaction transaction) {
        Entity issueEntity = XodusLocalOnlyIssueStore.findUnique(transaction, ISSUE_ENTITY_TYPE, UUID_PROPERTY_NAME, issueUuid).orElseGet(() -> transaction.newEntity(ISSUE_ENTITY_TYPE));
        Entity oldFileEntity = issueEntity.getLink(ISSUE_TO_FILE_LINK_NAME);
        if (oldFileEntity != null && !fileEntity.equals(oldFileEntity)) {
            oldFileEntity.deleteLink(FILE_TO_ISSUES_LINK_NAME, issueEntity);
        }
        issueEntity.setLink(ISSUE_TO_FILE_LINK_NAME, fileEntity);
        fileEntity.addLink(FILE_TO_ISSUES_LINK_NAME, issueEntity);
        issueEntity.setProperty(UUID_PROPERTY_NAME, (Comparable)issueUuid);
        return issueEntity;
    }

    private static void updateIssueEntity(Entity issueEntity, LocalOnlyIssue issue) {
        issueEntity.setProperty(UUID_PROPERTY_NAME, (Comparable)issue.getId());
        issueEntity.setProperty(RULE_KEY_PROPERTY_NAME, (Comparable)((Object)issue.getRuleKey()));
        issueEntity.setBlobString(MESSAGE_BLOB_NAME, issue.getMessage());
        LocalOnlyIssueResolution resolution = Objects.requireNonNull(issue.getResolution());
        issueEntity.setProperty(RESOLVED_STATUS_PROPERTY_NAME, (Comparable)((Object)resolution.getStatus()));
        issueEntity.setProperty(RESOLUTION_DATE_PROPERTY_NAME, (Comparable)resolution.getResolutionDate());
        String comment = resolution.getComment();
        if (comment != null) {
            issueEntity.setBlobString(COMMENT_PROPERTY_NAME, comment);
        }
        TextRangeWithHash textRange = issue.getTextRangeWithHash();
        LineWithHash lineWithHash = issue.getLineWithHash();
        if (textRange != null) {
            issueEntity.setProperty(START_LINE_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getStartLine()));
            issueEntity.setProperty(START_LINE_OFFSET_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getStartLineOffset()));
            issueEntity.setProperty(END_LINE_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getEndLine()));
            issueEntity.setProperty(END_LINE_OFFSET_PROPERTY_NAME, (Comparable)Integer.valueOf(textRange.getEndLineOffset()));
            issueEntity.setProperty(RANGE_HASH_PROPERTY_NAME, (Comparable)((Object)textRange.getHash()));
        }
        if (lineWithHash != null) {
            issueEntity.setProperty(LINE_HASH_PROPERTY_NAME, (Comparable)((Object)lineWithHash.getHash()));
            issueEntity.setProperty(START_LINE_PROPERTY_NAME, (Comparable)Integer.valueOf(lineWithHash.getNumber()));
        }
    }

    public Optional<LocalOnlyIssue> find(UUID issueId) {
        return (Optional)this.entityStore.computeInTransaction(txn -> XodusLocalOnlyIssueStore.findUnique(txn, ISSUE_ENTITY_TYPE, UUID_PROPERTY_NAME, issueId).map(XodusLocalOnlyIssueStore::adapt));
    }

    public void purgeIssuesOlderThan(Instant limit) {
        this.entityStore.executeInTransaction(txn -> txn.find(ISSUE_ENTITY_TYPE, RESOLUTION_DATE_PROPERTY_NAME, (Comparable)Instant.EPOCH, (Comparable)limit).forEach(issueEntity -> {
            Entity fileEntity = issueEntity.getLink(ISSUE_TO_FILE_LINK_NAME);
            if (fileEntity != null) {
                fileEntity.deleteLink(FILE_TO_ISSUES_LINK_NAME, issueEntity);
            }
            issueEntity.delete();
        }));
    }

    public void backup() {
        LOG.debug("Creating backup of local-only issue database in {}", (Object)this.backupFile);
        try {
            File backupTmp = CompressBackupUtil.backup((Backupable)this.entityStore, (File)this.backupFile.getParent().toFile(), (String)"local_only_issue_backup", (boolean)false);
            Files.move(backupTmp.toPath(), this.backupFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Exception e) {
            LOG.error("Unable to backup local-only issue database", e);
        }
    }

    public void close() {
        this.backup();
        this.entityStore.close();
        FileUtils.deleteQuietly(this.xodusDbDir.toFile());
    }
}

