/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.repository.connection;

import java.util.Objects;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.ConnectionKind;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;

public class SonarCloudConnectionConfiguration
extends AbstractConnectionConfiguration {
    private final String organization;

    public static String getSonarCloudUrl() {
        return System.getProperty("sonarlint.internal.sonarcloud.url", "https://sonarcloud.io");
    }

    public SonarCloudConnectionConfiguration(String connectionId, String organization, boolean disableNotifications) {
        super(connectionId, ConnectionKind.SONARCLOUD, disableNotifications, SonarCloudConnectionConfiguration.getSonarCloudUrl());
        this.organization = organization;
    }

    public String getOrganization() {
        return this.organization;
    }

    @Override
    public EndpointParams getEndpointParams() {
        return new EndpointParams(this.getUrl(), true, this.organization);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SonarCloudConnectionConfiguration that = (SonarCloudConnectionConfiguration)o;
        return Objects.equals(this.organization, that.organization);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.organization);
    }
}

