/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.developers;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.developers.Event;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonArray;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonElement;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonObject;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonParser;

public class DevelopersApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String API_PATH = "api/developers/search_events";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    private final ServerApiHelper helper;

    public DevelopersApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public boolean isSupported() {
        if (this.helper.isSonarCloud()) {
            return true;
        }
        String path = DevelopersApi.getWsPath(Collections.emptyMap());
        try (HttpClient.Response wsResponse = this.helper.rawGet(path);){
            boolean bl = wsResponse.isSuccessful();
            return bl;
        }
    }

    public List<Event> getEvents(Map<String, ZonedDateTime> projectTimestamps) {
        String path = DevelopersApi.getWsPath(projectTimestamps);
        try (HttpClient.Response wsResponse = this.helper.rawGet(path);){
            if (!wsResponse.isSuccessful()) {
                LOG.debug("Failed to get notifications: {}, {}", (Object)wsResponse.code(), (Object)wsResponse.bodyAsString());
                List<Event> list = Collections.emptyList();
                return list;
            }
            List<Event> list = DevelopersApi.parseResponse(wsResponse.bodyAsString());
            return list;
        }
    }

    private static List<Event> parseResponse(String contents) {
        ArrayList<Event> notifications = new ArrayList<Event>();
        try {
            JsonObject root = JsonParser.parseString(contents).getAsJsonObject();
            JsonArray events = root.get("events").getAsJsonArray();
            for (JsonElement el : events) {
                JsonObject event = el.getAsJsonObject();
                String category = DevelopersApi.getOrFail(event, "category");
                String message = DevelopersApi.getOrFail(event, "message");
                String link = DevelopersApi.getOrFail(event, "link");
                String projectKey = DevelopersApi.getOrFail(event, "project");
                String dateTime = DevelopersApi.getOrFail(event, "date");
                ZonedDateTime time = ZonedDateTime.parse(dateTime, TIME_FORMATTER);
                notifications.add(new Event(category, message, link, projectKey, time));
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse SonarQube notifications response", e);
            return Collections.emptyList();
        }
        return notifications;
    }

    private static String getOrFail(JsonObject parent, String name) {
        JsonElement element = parent.get(name);
        if (element == null) {
            throw new IllegalStateException("Failed to parse response. Missing field '" + name + "'.");
        }
        return element.getAsString();
    }

    private static String getWsPath(Map<String, ZonedDateTime> projectTimestamps) {
        StringBuilder builder = new StringBuilder();
        builder.append(API_PATH);
        builder.append("?projects=");
        builder.append(projectTimestamps.keySet().stream().map(UrlUtils::urlEncode).collect(Collectors.joining(",")));
        builder.append("&from=");
        builder.append(projectTimestamps.values().stream().map(timestamp -> timestamp.format(TIME_FORMATTER)).map(UrlUtils::urlEncode).collect(Collectors.joining(",")));
        return builder.toString();
    }
}

