/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.hotspot;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.VulnerabilityProbability;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.exception.UnexpectedBodyException;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspot;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspotDetails;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Common;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Hotspots;
import org.sonarsource.sonarlint.core.serverapi.source.SourceApi;
import org.sonarsource.sonarlint.core.serverapi.util.ProtobufUtil;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;

public class HotspotApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    public static final Version TRACKING_COMPATIBLE_MIN_SQ_VERSION = Version.create("9.7");
    public static final Version MIN_SQ_VERSION_SUPPORTING_PULL = Version.create("10.1");
    private static final String HOTSPOTS_SEARCH_API_URL = "/api/hotspots/search.protobuf";
    private static final String HOTSPOTS_SHOW_API_URL = "/api/hotspots/show.protobuf";
    private static final String HOTSPOTS_PULL_API_URL = "/api/hotspots/pull";
    private static final String PROJECT_KEY_QUERY_PARAM = "?projectKey=";
    private final ServerApiHelper helper;

    public HotspotApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public boolean permitsTracking(Supplier<Version> serverVersion) {
        return HotspotApi.permitsTracking(this.helper.isSonarCloud(), serverVersion);
    }

    public static boolean permitsTracking(boolean isSonarCloud, Supplier<Version> serverVersion) {
        return isSonarCloud || serverVersion.get().compareToIgnoreQualifier(TRACKING_COMPATIBLE_MIN_SQ_VERSION) >= 0;
    }

    public CompletableFuture<Void> changeStatusAsync(String hotspotKey, HotspotReviewStatus status) {
        boolean isReviewed = status.isReviewed();
        String webApiStatus = isReviewed ? "REVIEWED" : "TO_REVIEW";
        String body = "hotspot=" + UrlUtils.urlEncode(hotspotKey) + "&status=" + UrlUtils.urlEncode(webApiStatus);
        if (isReviewed) {
            body = body + "&resolution=" + UrlUtils.urlEncode(status.name());
        }
        return this.helper.postAsync("api/hotspots/change_status", "application/x-www-form-urlencoded", body).thenAccept(response -> {});
    }

    public Collection<ServerHotspot> getAll(String projectKey, String branchName, ProgressMonitor progress) {
        return this.searchHotspots(HotspotApi.getSearchUrl(projectKey, null, branchName), progress);
    }

    public Collection<ServerHotspot> getFromFile(String projectKey, String filePath, String branchName) {
        return this.searchHotspots(HotspotApi.getSearchUrl(projectKey, filePath, branchName), new ProgressMonitor(null));
    }

    public HotspotsPullResult pullHotspots(String projectKey, String branchName, Set<Language> enabledLanguages, @Nullable Long changedSince) {
        return ServerApiHelper.processTimed(() -> this.helper.get(HotspotApi.getPullHotspotsUrl(projectKey, branchName, enabledLanguages, changedSince)), response -> {
            InputStream input = response.bodyAsStream();
            Hotspots.HotspotPullQueryTimestamp timestamp = Hotspots.HotspotPullQueryTimestamp.parseDelimitedFrom(input);
            return new HotspotsPullResult(timestamp, ProtobufUtil.readMessages(input, Hotspots.HotspotLite.parser()));
        }, duration -> LOG.debug("Pulled issues in {}ms", (Object)duration));
    }

    private static String getPullHotspotsUrl(String projectKey, String branchName, Set<Language> enabledLanguages, @Nullable Long changedSince) {
        String enabledLanguageKeys = enabledLanguages.stream().map(Language::getLanguageKey).collect(Collectors.joining(","));
        StringBuilder url = new StringBuilder().append(HOTSPOTS_PULL_API_URL).append(PROJECT_KEY_QUERY_PARAM).append(UrlUtils.urlEncode(projectKey)).append("&branchName=").append(UrlUtils.urlEncode(branchName));
        if (!enabledLanguageKeys.isEmpty()) {
            url.append("&languages=").append(enabledLanguageKeys);
        }
        if (changedSince != null) {
            url.append("&changedSince=").append(changedSince);
        }
        return url.toString();
    }

    public boolean supportHotspotsPull(Supplier<Version> serverVersion) {
        return HotspotApi.supportHotspotsPull(this.helper.isSonarCloud(), serverVersion.get());
    }

    public static boolean supportHotspotsPull(boolean isSonarCloud, Version serverVersion) {
        return !isSonarCloud && serverVersion.compareToIgnoreQualifier(MIN_SQ_VERSION_SUPPORTING_PULL) >= 0;
    }

    private Collection<ServerHotspot> searchHotspots(String searchUrl, ProgressMonitor progress) {
        ArrayList<ServerHotspot> hotspots = new ArrayList<ServerHotspot>();
        HashMap componentPathsByKey = new HashMap();
        this.helper.getPaginated(searchUrl, Hotspots.SearchWsResponse::parseFrom, r -> r.getPaging().getTotal(), r -> {
            componentPathsByKey.clear();
            componentPathsByKey.putAll(r.getComponentsList().stream().collect(Collectors.toMap(Hotspots.Component::getKey, Hotspots.Component::getPath)));
            return r.getHotspotsList();
        }, hotspot -> {
            String filePath = (String)componentPathsByKey.get(hotspot.getComponent());
            if (filePath != null) {
                hotspots.add(HotspotApi.adapt(hotspot, filePath));
            } else {
                LOG.error("Error while fetching security hotspots, the component '" + hotspot.getComponent() + "' is missing");
            }
        }, false, progress);
        return hotspots;
    }

    private static String getSearchUrl(String projectKey, @Nullable String filePath, String branchName) {
        return "/api/hotspots/search.protobuf?projectKey=" + UrlUtils.urlEncode(projectKey) + (String)(filePath != null ? "&files=" + UrlUtils.urlEncode(filePath) : "") + "&branch=" + UrlUtils.urlEncode(branchName);
    }

    public CompletableFuture<ServerHotspotDetails> show(String hotspotKey) {
        return this.helper.getAsync(HotspotApi.getShowUrl(hotspotKey)).thenApply(response -> {
            try (HttpClient.Response response2 = response;){
                ServerHotspotDetails serverHotspotDetails;
                block14: {
                    InputStream is = response.bodyAsStream();
                    try {
                        serverHotspotDetails = HotspotApi.adapt(Hotspots.ShowWsResponse.parseFrom(is), null);
                        if (is == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return serverHotspotDetails;
            }
            catch (IOException e) {
                throw new UnexpectedBodyException(e);
            }
        });
    }

    public Optional<ServerHotspotDetails> fetch(String hotspotKey) {
        String codeSnippet;
        Hotspots.ShowWsResponse response;
        try (HttpClient.Response wsResponse = this.helper.get(HotspotApi.getShowUrl(hotspotKey));
             InputStream is = wsResponse.bodyAsStream();){
            response = Hotspots.ShowWsResponse.parseFrom(is);
        }
        catch (Exception e) {
            LOG.error("Error while fetching security hotspot", e);
            return Optional.empty();
        }
        String fileKey = response.getComponent().getKey();
        Optional<String> source = new SourceApi(this.helper).getRawSourceCode(fileKey);
        if (source.isPresent()) {
            try {
                codeSnippet = ServerApiUtils.extractCodeSnippet(source.get(), response.getTextRange());
            }
            catch (Exception e) {
                LOG.debug("Unable to compute code snippet of '" + fileKey + "' for text range: " + response.getTextRange(), (Object)e);
                codeSnippet = null;
            }
        } else {
            codeSnippet = null;
        }
        return Optional.of(HotspotApi.adapt(response, codeSnippet));
    }

    private static ServerHotspotDetails adapt(Hotspots.ShowWsResponse hotspot, @Nullable String codeSnippet) {
        return new ServerHotspotDetails(hotspot.getMessage(), hotspot.getComponent().getPath(), HotspotApi.convertTextRange(hotspot.getTextRange()), hotspot.getAuthor(), ServerHotspotDetails.Status.valueOf(hotspot.getStatus()), hotspot.hasResolution() ? ServerHotspotDetails.Resolution.valueOf(hotspot.getResolution()) : null, HotspotApi.adapt(hotspot.getRule()), codeSnippet, hotspot.getCanChangeStatus());
    }

    private static ServerHotspotDetails.Rule adapt(Hotspots.Rule rule) {
        return new ServerHotspotDetails.Rule(rule.getKey(), rule.getName(), rule.getSecurityCategory(), VulnerabilityProbability.valueOf(rule.getVulnerabilityProbability()), rule.getRiskDescription(), rule.getVulnerabilityDescription(), rule.getFixRecommendations());
    }

    private static ServerHotspot adapt(Hotspots.SearchWsResponse.Hotspot hotspot, String filePath) {
        return new ServerHotspot(hotspot.getKey(), hotspot.getRuleKey(), hotspot.getMessage(), filePath, HotspotApi.convertTextRange(hotspot.getTextRange()), ServerApiUtils.parseOffsetDateTime(hotspot.getCreationDate()).toInstant(), HotspotApi.getStatus(hotspot), VulnerabilityProbability.valueOf(hotspot.getVulnerabilityProbability()), hotspot.getAssignee());
    }

    private static HotspotReviewStatus getStatus(Hotspots.SearchWsResponse.Hotspot hotspot) {
        String status = hotspot.getStatus();
        String resolution = hotspot.hasResolution() ? hotspot.getResolution() : null;
        return HotspotReviewStatus.fromStatusAndResolution(status, resolution);
    }

    private static String getShowUrl(String hotspotKey) {
        return "/api/hotspots/show.protobuf?hotspot=" + UrlUtils.urlEncode(hotspotKey);
    }

    private static TextRangeWithHash convertTextRange(Common.TextRange textRange) {
        return new TextRangeWithHash(textRange.getStartLine(), textRange.getStartOffset(), textRange.getEndLine(), textRange.getEndOffset(), "");
    }

    public static class HotspotsPullResult {
        private final Hotspots.HotspotPullQueryTimestamp timestamp;
        private final List<Hotspots.HotspotLite> hotspots;

        public HotspotsPullResult(Hotspots.HotspotPullQueryTimestamp timestamp, List<Hotspots.HotspotLite> hotspots) {
            this.timestamp = timestamp;
            this.hotspots = hotspots;
        }

        public Hotspots.HotspotPullQueryTimestamp getTimestamp() {
            return this.timestamp;
        }

        public List<Hotspots.HotspotLite> getHotspots() {
            return this.hotspots;
        }
    }
}

