/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;

public class StorageFacade {
    private final Path globalStorageRoot;
    private final Path workDir;
    private final Map<String, ConnectionStorage> connectionStorageById = new ConcurrentHashMap<String, ConnectionStorage>();

    public StorageFacade(Path globalStorageRoot, Path workDir) {
        this.globalStorageRoot = globalStorageRoot;
        this.workDir = workDir;
    }

    public ConnectionStorage connection(String connectionId) {
        return this.connectionStorageById.computeIfAbsent(connectionId, k -> new ConnectionStorage(this.globalStorageRoot, this.workDir, connectionId));
    }

    public void close() {
        this.connectionStorageById.values().forEach(ConnectionStorage::close);
    }
}

