/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.events.taint;

import java.util.List;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.serverapi.push.TaintVulnerabilityRaisedEvent;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.events.ServerEventHandler;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerTaintIssue;

public class UpdateStorageOnTaintVulnerabilityRaised
implements ServerEventHandler<TaintVulnerabilityRaisedEvent> {
    private final ConnectionStorage storage;

    public UpdateStorageOnTaintVulnerabilityRaised(ConnectionStorage storage) {
        this.storage = storage;
    }

    @Override
    public void handle(TaintVulnerabilityRaisedEvent event) {
        ServerTaintIssue issue = new ServerTaintIssue(event.getKey(), false, event.getRuleKey(), event.getMainLocation().getMessage(), event.getMainLocation().getFilePath(), event.getCreationDate(), event.getSeverity(), event.getType(), UpdateStorageOnTaintVulnerabilityRaised.adapt(event.getMainLocation().getTextRange()), event.getRuleDescriptionContextKey(), event.getCleanCodeAttribute().orElse(null), event.getImpacts()).setFlows(UpdateStorageOnTaintVulnerabilityRaised.adapt(event.getFlows()));
        this.storage.project(event.getProjectKey()).findings().insert(event.getBranchName(), issue);
    }

    private static List<ServerTaintIssue.Flow> adapt(List<TaintVulnerabilityRaisedEvent.Flow> flows) {
        return flows.stream().map(UpdateStorageOnTaintVulnerabilityRaised::adapt).collect(Collectors.toList());
    }

    private static ServerTaintIssue.Flow adapt(TaintVulnerabilityRaisedEvent.Flow flow) {
        return new ServerTaintIssue.Flow(flow.getLocations().stream().map(UpdateStorageOnTaintVulnerabilityRaised::adapt).collect(Collectors.toList()));
    }

    private static ServerTaintIssue.ServerIssueLocation adapt(TaintVulnerabilityRaisedEvent.Location location) {
        return new ServerTaintIssue.ServerIssueLocation(location.getFilePath(), UpdateStorageOnTaintVulnerabilityRaised.adapt(location.getTextRange()), location.getMessage());
    }

    public static TextRangeWithHash adapt(TaintVulnerabilityRaisedEvent.Location.TextRange range) {
        return new TextRangeWithHash(range.getStartLine(), range.getStartLineOffset(), range.getEndLine(), range.getEndLineOffset(), range.getHash());
    }
}

