/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.nio.file.Path;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.telemetry.TelemetryClientAttributesProvider;
import org.sonarsource.sonarlint.core.telemetry.TelemetryHttpClient;
import org.sonarsource.sonarlint.core.telemetry.TelemetryLocalStorage;
import org.sonarsource.sonarlint.core.telemetry.TelemetryLocalStorageManager;
import org.sonarsource.sonarlint.core.telemetry.TelemetryUtils;

public class TelemetryManager {
    static final int MIN_HOURS_BETWEEN_UPLOAD = 5;
    private final TelemetryLocalStorageManager storage;
    private final TelemetryHttpClient client;
    private final TelemetryClientAttributesProvider attributesProvider;

    public TelemetryManager(Path path, TelemetryHttpClient client, TelemetryClientAttributesProvider attributesProvider) {
        this.storage = this.newTelemetryStorage(path);
        this.attributesProvider = attributesProvider;
        this.client = client;
    }

    TelemetryLocalStorageManager newTelemetryStorage(Path path) {
        return new TelemetryLocalStorageManager(path);
    }

    public boolean isEnabled() {
        return this.storage.tryRead().enabled();
    }

    public void enable() {
        this.storage.tryUpdateAtomically(data -> data.setEnabled(true));
        this.uploadLazily();
    }

    public void disable() {
        this.storage.tryUpdateAtomically(data -> {
            data.setEnabled(false);
            this.client.optOut((TelemetryLocalStorage)data, this.attributesProvider);
        });
    }

    public void uploadLazily() {
        TelemetryLocalStorage readData = this.storage.tryRead();
        if (!TelemetryUtils.dayChanged(readData.lastUploadTime(), 5L)) {
            return;
        }
        this.storage.tryUpdateAtomically(data -> {
            this.client.upload((TelemetryLocalStorage)data, this.attributesProvider);
            data.setLastUploadTime();
            data.clearAfterPing();
        });
    }

    public void analysisDoneOnSingleLanguage(@Nullable Language language, int analysisTimeMs) {
        this.storage.tryUpdateAtomically(data -> {
            if (language == null) {
                data.setUsedAnalysis("others", analysisTimeMs);
            } else {
                data.setUsedAnalysis(language.getLanguageKey(), analysisTimeMs);
            }
        });
    }

    public void analysisDoneOnMultipleFiles() {
        this.storage.tryUpdateAtomically(TelemetryLocalStorage::setUsedAnalysis);
    }

    public void devNotificationsReceived(String eventType) {
        this.storage.tryUpdateAtomically(s -> s.incrementDevNotificationsCount(eventType));
    }

    public void devNotificationsClicked(String eventType) {
        this.storage.tryUpdateAtomically(s -> s.incrementDevNotificationsClicked(eventType));
    }

    public void showHotspotRequestReceived() {
        this.storage.tryUpdateAtomically(TelemetryLocalStorage::incrementShowHotspotRequestCount);
    }

    public void taintVulnerabilitiesInvestigatedLocally() {
        this.storage.tryUpdateAtomically(TelemetryLocalStorage::incrementTaintVulnerabilitiesInvestigatedLocallyCount);
    }

    public void taintVulnerabilitiesInvestigatedRemotely() {
        this.storage.tryUpdateAtomically(TelemetryLocalStorage::incrementTaintVulnerabilitiesInvestigatedRemotelyCount);
    }

    public void addReportedRules(Set<String> ruleKeys) {
        this.storage.tryUpdateAtomically(s -> s.addReportedRules(ruleKeys));
    }

    public void addQuickFixAppliedForRule(String ruleKey) {
        this.storage.tryUpdateAtomically(s -> s.addQuickFixAppliedForRule(ruleKey));
    }

    public void helpAndFeedbackLinkClicked(String itemId) {
        this.storage.tryUpdateAtomically(s -> s.helpAndFeedbackLinkClicked(itemId));
    }

    public void smartNotificationsSent(String itemId) {
        this.storage.tryUpdateAtomically(s -> s.helpAndFeedbackLinkClicked(itemId));
    }

    public void stop() {
        this.uploadLazily();
    }
}

