/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;
import org.sonarsource.sonarlint.core.serverconnection.issues.LineLevelServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.RangeLevelServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerIssue;

public class ServerIssueTrackable
implements Trackable {
    private final ServerIssue serverIssue;

    public ServerIssueTrackable(ServerIssue serverIssue) {
        this.serverIssue = serverIssue;
    }

    public ServerIssue getServerIssue() {
        return this.serverIssue;
    }

    public Object getClientObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRuleKey() {
        return this.serverIssue.getRuleKey();
    }

    @Override
    public IssueSeverity getSeverity() {
        return this.serverIssue.getUserSeverity();
    }

    @Override
    public RuleType getType() {
        return this.serverIssue.getType();
    }

    @Override
    public String getMessage() {
        return this.serverIssue.getMessage();
    }

    @Override
    public Integer getLine() {
        if (this.serverIssue instanceof LineLevelServerIssue) {
            return ((LineLevelServerIssue)this.serverIssue).getLine();
        }
        if (this.serverIssue instanceof RangeLevelServerIssue) {
            return ((RangeLevelServerIssue)this.serverIssue).getTextRange().getStartLine();
        }
        return null;
    }

    @Override
    public String getLineHash() {
        if (this.serverIssue instanceof LineLevelServerIssue) {
            return ((LineLevelServerIssue)this.serverIssue).getLineHash();
        }
        return null;
    }

    @Override
    public TextRangeWithHash getTextRange() {
        if (this.serverIssue instanceof RangeLevelServerIssue) {
            return ((RangeLevelServerIssue)this.serverIssue).getTextRange();
        }
        return null;
    }

    @Override
    public Long getCreationDate() {
        return this.serverIssue.getCreationDate().toEpochMilli();
    }

    @Override
    public String getServerIssueKey() {
        return this.serverIssue.getKey();
    }

    @Override
    public boolean isResolved() {
        return this.serverIssue.isResolved();
    }

    @Override
    public HotspotReviewStatus getReviewStatus() {
        return null;
    }
}

