/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.issuetracking.CachingIssueTracker;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspot;
import org.sonarsource.sonarlint.core.serverconnection.DownloadException;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBinding;
import org.sonarsource.sonarlint.core.tracking.ServerHotspotTrackable;

public class ServerIssueTracker {
    private static final SonarLintLogger LOGGER = SonarLintLogger.get();
    private final CachingIssueTracker hotspotTracker;

    public ServerIssueTracker(CachingIssueTracker hotspotTracker) {
        this.hotspotTracker = hotspotTracker;
    }

    public void update(EndpointParams endpoint, HttpClient client, ConnectedSonarLintEngine engine, ProjectBinding projectBinding, Collection<String> fileKeys, String branchName) {
        this.update(fileKeys, fileKey -> ServerIssueTracker.fetchServerHotspots(endpoint, client, engine, projectBinding, fileKey, branchName));
    }

    public void update(ConnectedSonarLintEngine engine, ProjectBinding projectBinding, String branchName, Collection<String> fileKeys) {
        this.update(fileKeys, fileKey -> engine.getServerHotspots(projectBinding, branchName, (String)fileKey));
    }

    private void update(Collection<String> fileKeys, Function<String, Collection<ServerHotspot>> hotspotsGetter) {
        try {
            for (String fileKey : fileKeys) {
                Collection<ServerHotspot> serverHotspots = hotspotsGetter.apply(fileKey);
                Collection serverHotspotsTrackable = serverHotspots.stream().map(ServerHotspotTrackable::new).collect(Collectors.toList());
                this.hotspotTracker.matchAndTrackAsBase(fileKey, serverHotspotsTrackable);
            }
        }
        catch (Exception e) {
            LOGGER.error("error while fetching and matching server issues", e);
        }
    }

    private static Collection<ServerHotspot> fetchServerHotspots(EndpointParams endpoint, HttpClient client, ConnectedSonarLintEngine engine, ProjectBinding projectBinding, String ideFilePath, String branchName) {
        try {
            LOGGER.debug("fetchServerHotspots projectKey=" + projectBinding.projectKey() + ", ideFilePath=" + ideFilePath + ", branchName=" + branchName);
            engine.downloadAllServerHotspotsForFile(endpoint, client, projectBinding, ideFilePath, branchName, null);
        }
        catch (DownloadException e) {
            LOGGER.debug("Failed to download server hotspots", (Object)e);
        }
        return engine.getServerHotspots(projectBinding, branchName, ideFilePath);
    }
}

