/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.dotnet.resource.parser;

import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.dotnet.resource.parser.EProjectXmlAttribute;
import org.conqat.engine.dotnet.resource.parser.EProjectXmlElement;
import org.conqat.engine.dotnet.resource.parser.ProjectParser;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;

class ProjectParser8
extends ProjectParser {
    protected ProjectParser8(String projectFileContent) {
        super(projectFileContent);
    }

    @Override
    public ProjectParser.SourceFileProcessor createSourceFileProcessor() {
        return new IncludeProcessor();
    }

    private class IncludeProcessor
    extends ProjectParser.SourceFileProcessor {
        private IncludeProcessor() {
        }

        public EProjectXmlElement getTargetElement() {
            return EProjectXmlElement.Include;
        }

        public void process() throws ConQATException {
            ProjectParser8.this.processChildElements(new FileProcessor());
        }

        private class FileProcessor
        implements IXMLElementProcessor<EProjectXmlElement, ConQATException> {
            private FileProcessor() {
            }

            public EProjectXmlElement getTargetElement() {
                return EProjectXmlElement.File;
            }

            public void process() {
                String relativeSourceElementName = ProjectParser8.this.getStringAttribute(EProjectXmlAttribute.RelPath);
                String buildAction = ProjectParser8.this.getStringAttribute(EProjectXmlAttribute.BuildAction);
                if (buildAction != null && buildAction.equals("Compile")) {
                    String link = ProjectParser8.this.getStringAttribute(EProjectXmlAttribute.Link);
                    if (!StringUtils.isEmpty((String)link)) {
                        relativeSourceElementName = link;
                    }
                    IncludeProcessor.this.addSourceFile(relativeSourceElementName);
                }
            }
        }
    }
}

