/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.forgerockds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.forgerockds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ChangeSequenceNumberResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String CHANGE_SEQUENCE_NUMBER_RESPONSE_OID = "1.3.6.1.4.1.42.2.27.9.5.9";
    private static final long serialVersionUID = 1107845623167919411L;
    @NotNull
    private final String csn;

    ChangeSequenceNumberResponseControl() {
        this.csn = null;
    }

    public ChangeSequenceNumberResponseControl(@NotNull String csn) {
        super(CHANGE_SEQUENCE_NUMBER_RESPONSE_OID, false, new ASN1OctetString(csn));
        Validator.ensureNotNull(csn);
        this.csn = csn;
    }

    public ChangeSequenceNumberResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_CSN_RESPONSE_NO_VALUE.get());
        }
        this.csn = value.stringValue();
    }

    @Override
    @NotNull
    public ChangeSequenceNumberResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new ChangeSequenceNumberResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static ChangeSequenceNumberResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(CHANGE_SEQUENCE_NUMBER_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof ChangeSequenceNumberResponseControl) {
            return (ChangeSequenceNumberResponseControl)c;
        }
        return new ChangeSequenceNumberResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    public String getCSN() {
        return this.csn;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_CSN_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ChangeSequenceNumberResponseControl(csn='");
        buffer.append(this.csn);
        buffer.append("')");
    }
}

