In ABAP, comparisons with booleans should be done with `abap_true` and `abap_false`.
The character equivalents `'X'` and `' '` or `space` make it harder to recognize the comparison as a boolean expression. 
Therefore, the character equivalents should always be replaced with the boolean constants.



# How Can I Resolve This?

Replace the constant `'X'` with `abap_true` and replace the constants `' '` or `space` with `abap_false`.

## Example (Before)

```ABAP
IF value = 'X'.

ELSEIF value = space.

ENDIF.

WHILE value <> 'X'.

    CHECK value2 = space.

ENDWHILE.

result = COND # (WHEN value = ' ' THEN 1 ELSE 2 ).

CASE 'X'.
    WHEN value.
    
    WHEN value2.
ENDCASE.

CASE value.
    WHEN 'X'.
    
    WHEN space.
ENDCASE.
```

## Example (After)

```ABAP
IF value = abap_true.

ELSEIF value = abap_false.

ENDIF.

WHILE value <> abap_true.

    CHECK value2 = abap_false.

ENDWHILE.

result = COND # (WHEN value = abap_false THEN 1 ELSE 2 ).

CASE abap_true.
    WHEN value.
    
    WHEN value2.
ENDCASE.

CASE value.
    WHEN abap_true.
    
    WHEN abap_false.
ENDCASE.
```

# Where Can I Learn More?

## References

- [Clean ABAP guideline, Use ABAP_TRUE and ABAP_FALSE for comparisons](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#use-abap_true-and-abap_false-for-comparisons)