This check detects the instances of `FORM` and `FUNCTION` module definitions which are often associated with procedural programming in ABAP code.

# Why is This a Problem?
Object-oriented programming is generally considered to be more maintainable and extensible, and should be preferred over classic procedural ABAP where possible.

# Exceptions
`FUNCTION` modules are still required for Remote Function Call (RFC).

# How Can I Resolve This?
Consider refactoring the procedural code to use object-oriented programming principles where possible. Specifically, you should replace the instances of `FORM` and `FUNCTION` with object-oriented alternatives, e.g., classes and interfaces.

## Example (Before)
```ABAP
FORM calculate_area.
  DATA: width TYPE i,
        length TYPE i,
        area TYPE i.
        
  area = width * length.
  
  WRITE: / 'The area is ', area.
ENDFORM.
```

## Example (After)
```ABAP
CLASS rectangle DEFINITION.
  PUBLIC SECTION.
    DATA: width TYPE i,
          length TYPE i.
          
    METHOD: claculate_area RETURNING VALUE(result) TYPE i.
ENDCLASS.

CLASS rectangle IMPLEMENTATION.
  METHOD calculate_area.
    result = width * length.
  ENDMETHOD.
ENDCLASS.
```

# Where Can I Learn More?

## References
- [ABAP Objects as a Programming Model](https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-us/abenabap_obj_progr_model_guidl.htm)
- [Clean ABAP: Prefer object orientation to procedural programming](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#prefer-object-orientation-to-procedural-programming)