This check finds occurrences of invocations of equality comparison methods where an object is compared to itself.


# Why is This a Problem?

Comparisons of an object to itself are usually not intentional since the comparison always yields the same result (`true`), assuming a correct implementation of the equality comparison method.

## Example

```java
SomeClass myObject = new SomeClass();
if(myObject.equals(myObject)) { // <-- comparison of myObject with itself
    // do something
}
```

## Exceptions

In test scenarios where the equality comparison method itself is tested, comparing an object with itself is a common and valid operation.


# How Can I Resolve This?

Correct the method argument of the comparison to the object that should actually be compared.