In classes fields should be defined before methods to improve code readability and maintainability. Consider ordering field definitions before method definitions in classes.

# What Does This Check Look For?

This check looks for classes where methods are defined before fields. If the respective check option is enabled, constructors are allowed to come before field definitions.

For C# and Gosu, properties are also considered fields. 

# Why is This a Problem?

Ordering field and method definitions in a consistent manner can greatly enhance the ease with which a class can be read and understood. Classes where methods precede fields can disrupt the natural flow of understanding the capabilities and data of the class. It might also lead to a situation where developers spend unnecessary time searching for field definitions, which hampers productivity and increases the risk of errors.

# How Can I Resolve This?

Consider defining all fields at the beginning of a class, before any methods. This groups fields together and methods afterward, making the class's structure more predictable and easier to follow.

# Examples

This example uses Java, but the principle generalizes to other languages to which this check applies: C#, C++ and Gosu.

## Non-Compliant

```java
class MyClass {
    void doSomething() {
        // Method implementation
    }
    
    int myVariable;
}
```

## Compliant

```java
class MyClass {
    int myVariable;
    
    void doSomething() {
        // Method implementation
    }
}
```
