Using built-in names as identifiers can lead to confusion and errors in the code.
Choose descriptive and meaningful names that do not shadow existing names.

# Why is This a Problem?

Using built-in names as identifiers can lead to confusion and unintended behavior.
An intended usage of the built-in functionality might be redirected unintentionally.
This can lead to bugs that are difficult to diagnose and fix.

# How Can I Resolve This?

Choose descriptive names that accurately convey the purpose and functionality of the identifier.
If necessary, modify the identifier to make it unique and distinct from any built-in names.

# Exceptions
Class and instance members can use the names of built-ins as identifiers because they do not shadow them.

# Examples
## Non-Compliant

```python
id = 42              # non-compliant: hides built-in id() function

def open(fileName):  # non-compliant: hides built-in open() function
    pass
```

## Compliant

```python
identifier = 42                     # compliant

def open_file(fileName):            # compliant
    pass
    
class MyClass:
    iter: int                       # compliant
    
    def __init__(self, id: str):    # compliant
        self.id = id                # compliant
        self.open = True            # compliant
    
    def dir():                      # compliant
        pass
```

# Where Can I Learn More?

* [Python documentation: Built-in Types](https://docs.python.org/3.8/library/stdtypes.html)
* [Python documentation: Built-in Functions](https://docs.python.org/3/library/functions.html)
