Avoid using ternary operators.

# Why is This a Problem?
Ternary operators make debugging difficult and represent code that is hard to read.

## Exceptions
In basic expressions, ternary operators might be tolerable. For example:
```java
int x = (a == 10) ? b : c;
```

# How Can I Resolve This?
This can be resolved by using an if-else block

## Example (Before)

```java
String weather = temperature > 25 ? "The weather is good today"
                                  : "It is quite cold today";
```

## Example (After)

```java
String weather;
if (temperature > 25) {
  weather = "The weather is good today";
} else {
  weather = "It is quite cold today";	
}
```
