Ordering class variables by their visibility improves readability and maintainability. Consider following a consistent ordering convention for access modifiers.

# What Does This Check Look For?

This check reports a finding when class variables in Java are not ordered according to their visibility in the sequence: public, protected, package (default), private.

# Why is This a Problem?

Ordering class variables by visibility makes it easier for developers to locate and reason about variables' accessibility within and outside the class. A consistent order aids in maintaining code, as it reduces the cognitive load required to understand the structure of a class. It promotes a standardized coding style, which can be particularly helpful in team environments or when contributing to open-source projects. Disorder in member visibility can lead to difficulty in understanding the access level of class variables, potentially causing misuse or unintended access.

# How Can I Resolve This?

Reorder class variables to adhere to the visibility order: public, protected, package (no modifier), then private. This improves the comprehensibility of your code. By doing so, you make your class's structure more predictable and easier to navigate for yourself and others who may work with your code in the future.

# Examples

## Non-Compliant

```java
class MyClass {
    private int privateField;
    public static final int CONSTANT = 42;
}
```

## Compliant

```java
class MyClass {
	public static final int CONSTANT = 42;
	private int privateField;
}
```

# Where Can I Learn More?

- [Guideline: Oracle Java Code Conventions: 3.1.3 Class and Interface Declarations](https://www.oracle.com/java/technologies/javase/codeconventions-fileorganization.html)
