Creating exceptions without throwing them can lead to confusion and possibly a lack of error detection.
Consider throwing the new exception where it is needed, or removing the unused exception construction.

# What Does This Check Look For?

This check identifies instances where a new exception is instantiated using `new` but not subsequently thrown with the `throw` keyword, potentially indicating an oversight or an error in the error handling logic.

# Why is This a Problem?

Exceptions are a central part of error handling in many programming languages, allowing for clear separation between normal control flow and error handling.
Creating an exception and not throwing it might imply a misunderstanding of exception usage or a potential error in the code where an exception was meant to be used to signal an issue but is instead never reported.
This can lead to errors that are hard to diagnose because the system's behavior does not change in the face of faults that should have disrupted its execution.

# How Can I Resolve This?

You should verify whether the exception was intended to be thrown and simply lacks the `throw` keyword. If that is the case, add `throw` before the exception creation to ensure the exception is properly signaled.
If the exception was not meant to be thrown and serves no purpose, it should be removed to avoid confusion and potential resource waste on unnecessary object creation.

# Examples

## Non-Compliant

```java
Exception e = new Exception("Error occurred."); // non-compliant: Exception created but not thrown.
```

## Compliant

```java
throw new Exception("Error occurred."); // compliant: Exception is thrown, signaling an error as intended.
```
