Creating extra objects unnecessarily can strain memory resources and degrade performance.
Avoid using constructors that don't add functional value and directly use value types or literals instead.

# What Does This Check Look For?

This check looks for uses of constructors that are discouraged, such as those of primitive wrappers (`Integer`, `Boolean`, etc.) and `String` objects, when alternatives are available.

# Why is This a Problem?

Using constructors like those for primitive wrappers and `String` objects can create extra, unnecessary objects.
These objects consume additional memory and processing power, reducing the efficiency of the application.
Especially in tight loops or high-load scenarios, the impact on performance can be significant.
This practice contradicts modern Java performance optimization principles.

# How Can I Resolve This?

Replace calls to unnecessary constructors with direct usage of primitive types or string literals.
For example, instead of using `new Integer(5)`, simply use `5`, and instead of `new String("example")`, use `"example"`.
This change reduces the number of object creations, leading to better memory usage and potentially improved application performance.