Attempting to destroy a class derived from a baseclass with public but non-virtual destructor has an undefined result.

# What Does This Check Look For?

This check looks for classes where a base classes' destructor is **not** public `virtual`, public `override`, or `protected` non-virtual.  
It can be configured to include structs and `final` classes, as well.

# Why is This a Problem?

If a class has a public but non-virtual destructor, then attempting to destroy a derived class through a base class pointer has an undefined result.

# How Can I Resolve This?

If the class is intended as a base class, mark the destructor as `virtual`.
If the class is not intended as a base class, then the class should be declared as `final`.

# Examples
## Non-Compliant

```cpp
class Base {
    public:
        ~D() { /* ... do some cleanup ... */ }
};
```

## Compliant

```cpp
class Base {
    public:
        virtual ~D() { /* ... do some cleanup ... */ }
};
```

# Where Can I Learn More?

- [AUTOSAR rule A12-4-1 - Destructor of a base class shall be public virtual, public override, or protected non-virtual.](https://www.autosar.org/fileadmin/standards/R22-11/AP/AUTOSAR_RS_CPP14Guidelines.pdf)
- [AUTOSAR rule A12-4-2 - If a public destructor of a class is non-virtual, then the class should be declared final.](https://www.autosar.org/fileadmin/standards/R22-11/AP/AUTOSAR_RS_CPP14Guidelines.pdf)
- [Guideline: C++ Core Guidelines: C.35 - A base class destructor should be either public and virtual, or protected and non-virtual](https://isocpp.github.io/CppCoreGuidelines/CppCoreGuidelines#c35-a-base-class-destructor-should-be-either-public-and-virtual-or-protected-and-non-virtual)
- [Guideline: C++ Core Guidelines: C.127 - A class with a virtual function should have a virtual or protected destructor](https://isocpp.github.io/CppCoreGuidelines/CppCoreGuidelines#c127-a-class-with-a-virtual-function-should-have-a-virtual-or-protected-destructor)
