Indefinite temporal keywords introduce ambiguity into requirement definitions. Be explicit about temporal dependencies to enhance clarity.

## What Does This Check Look For?

This check reports a finding if a field of an item contains indefinite temporal keywords such as "eventually", "until", "before", or "at last".

## Why is This a Problem?

The use of indefinite temporal keywords in requirements entails the risk of misinterpretation among different stakeholders.
Misinterpretations can potentially lead to unexpected behavior, software bugs, or even the failure to meet the actual requirement.
    
## How Can I Resolve This?

Replace indefinite temporal keywords with specific, quantifiable time frames or sequences. If the requirement relates to a sequence of tasks, establish specific, numbered steps. 
If it pertains to something happening after a length of time, replace the indefinite temporal keyword with a specific duration or time.

## Examples

### Non-Compliant

```txt
# Spec Item Title
Description: After the user logs in, the system should eventually display the home page.

// non-compliant: The use of "eventually" does not clearly indicate when the home page should display.
```

### Compliant

```txt
# Spec Item Title
Description: 
1. successful login
2. the system displays the home page within 3 seconds.

// compliant: Specific time frame provides clear expectations.
```

## Where Can I Learn More?

- Guideline: INCOSE R35: Define temporal dependencies explicitly instead of using indefinite temporal keywords such as “eventually”, “until”, “before”, “after”, “as”, “once”, “earliest”, “latest”, “instantaneous”, “simultaneous”, “at last”.