Exceeding the predefined word count limit can lead to excessively detailed or confusing software specifications.  
It is crucial to articulate requirements and test cases concisely for better understanding and productivity.

# What Does This Check Look For?

This check searches for software specification items, such as requirement descriptions and test cases,
that exceed the predefined word count limit.
It reports a finding when the number of words in any predefined fields of the specification items exceeds this limit.

# Why is This a Problem?
Extensive descriptions in software specifications can become a problem due to multiple reasons:
- **Misunderstanding:** It might result in misunderstandings or misinterpretations due to information overload; the more complex the description, the more room for errors in understanding.
- **Inefficiencies:** It could lead to unnecessary development work or testing, creating inefficiencies in the project lifecycle and potentially delaying project delivery times.

# How Can I Resolve This?

To address this issue, consider the following recommendations:

- **Refinement of Descriptions:** Review the flagged specification item and break down complex ideas into simpler, bite-sized elements.
- **Clarity and Conciseness:** Use clear and precise language to express the functionality or tests without compromising essential details.
- **Consider Splitting Requirements:** If reducing the word count without losing vital information proves challenging, consider splitting the requirement into multiple smaller specifications.

# Examples
## Non-Compliant

```markdown
# Spec Item Title
Requirement Description:
Implement a feature that allows users to sign in using their social media accounts,
the feature must include a sign-in button on the login page,
redirect the user to the respective social media page for authentication,
and then redirects back to the home page on successful sign-in.
The feature should also handle errors such as wrong password input,
in such a way that it informs users about the error and asks them to retry logging in,
all these while ensuring users' data privacy and security.

// non-compliant: Exceeds predefined word count.
```

## Compliant

```markdown
# Spec Item Title
Requirement Description:
Implement a social media sign-in feature.
Must include a sign-in button, provide redirection for authentication, handle errors, and maintain data privacy.

// compliant: Brief and clear language within the word count limit.
```

# Where Can I Learn More?
- [Guideline: IEEE 830-1998: Recommended Practice for Software Requirements Specifications](https://standards.ieee.org/ieee/830/1222/): IEEE standard for software requirements specifications.
- [Guideline: ISO/IEC/IEEE 29148:2018 Systems and software engineering — Life cycle processes — Requirements engineering](https://www.iso.org/standard/72089.html): International standard for requirements engineering in the software and systems engineering life cycle.