<h2>Why is this an issue?</h2>
<p>Assertion methods&nbsp;are throwing a "<code>java.lang.AssertionError</code>". If this call is done within the try block of a try-catch catching a
similar error, you should make sure to test some properties of the exception. Otherwise, the assertion will never fail.</p>
<h3>Noncompliant code example</h3>

```java
@Test
public void should_throw_assertion_error() {
  try {
    throwAssertionError();
    Assert.fail("Expected an AssertionError!"); // Noncompliant, the AssertionError will be caught and the test will never fail.
  } catch (AssertionError e) {}
}

private void throwAssertionError() {
  throw new AssertionError("My assertion error");
}
```
<h3>Compliant solution</h3>

```java
assertThrows(AssertionError.class, () -> throwAssertionError());
```

```java
try {
   throwAssertionError();
   Assert.fail("Expected an AssertionError!"); // Compliant, we made sure to test that the correct error is raised
 } catch (AssertionError e) {
   Assert.assertThat(e.getMessage(), is("My assertion error"));
 }
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://github.com/junit-team/junit4/wiki/Exception-testing">JUnit 4 exception testing documentation</a> </li>
</ul>