<p>XML standard allows the inclusion of XML files with the <code>xinclude</code> element. When an XML parser component is set up with the
<code>http://apache.org/xml/features/xinclude</code> feature, it will follow the standard and allow the inclusion of remote files.</p>
<h2>Why is this an issue?</h2>
<p>When the XML parser will encounter an <code>xinclude</code> element, it will try to load the file pointed to by the <code>href</code> attribute
into the document. Included files can either be local files found on the file system of the application server, or remote files that are downloaded
over HTTP, SMB, or other protocols, depending on the capabilities of the application and server.</p>
<p>The files that can be accessed that way are only limited by the entitlement of the application on the local system and the network filtering the
server is subject to.</p>
<p>This issue is particularly severe when the XML parser is used to parse untrusted documents. For example, when user-submitted XML messages are
parsed that way.</p>
<h3>What is the potential impact?</h3>
<p>Allowing the inclusion of arbitrary files in XML documents can have two main consequences depending on what type of file is included: local or
remote.</p>
<h4>Sensitive file disclosure</h4>
<p>If the application allows the inclusion of arbitrary files through the use of the <code>xinclude</code> element, it might be used to disclose
arbitrary files from the local file system. Depending on the application’s permissions on the file system, configuration files, runtime secrets, or
Personally Identifiable Information could be leaked.</p>
<p>This is particularly true if the affected parser is used to process untrusted XML documents.</p>
<h4>Server-side request forgery</h4>
<p>When used to retrieve remote files, the application will send network requests to remote hosts. Moreover, it will do so from its current network
location, which can have severe consequences if the application server is located on a sensitive network, such as the company corporate network or a
DMZ hosting other applications.</p>
<p>Attackers exploiting this issue could try to access internal backend services or corporate file shares. It could allow them to access more
sensitive files, bypass authentication mechanisms from frontend applications, or exploit further vulnerabilities in the local services. Note that, in
some cases, the requests sent from the application can be automatically authenticated on federated locations. This is often the case in Windows
environments when using Active Directory federated authentication.</p>
<h2>How to fix it in Java SE</h2>
<h3>Code examples</h3>
<p>The following code is vulnerable because it explicitly enables the <code>xinclude</code> feature.</p>
<h4>Noncompliant code example</h4>

```java
import javax.xml.parsers.SAXParserFactory;

SAXParserFactory factory = SAXParserFactory.newInstance();

factory.setXIncludeAware(true); // Noncompliant
factory.setFeature("http://apache.org/xml/features/xinclude", true); // Noncompliant
```
<h4>Compliant solution</h4>

```java
import javax.xml.parsers.SAXParserFactory;

SAXParserFactory factory = SAXParserFactory.newInstance();

factory.setXIncludeAware(false);
factory.setFeature("http://apache.org/xml/features/xinclude", false);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> OWASP - <a href="https://cheatsheetseries.owasp.org/cheatsheets/XML_External_Entity_Prevention_Cheat_Sheet.html#java">OWASP XXE Prevention
  Cheat Sheet</a> </li>
  <li> Java documentation - <a
  href="https://docs.oracle.com/en/java/javase/13/security/java-api-xml-processing-jaxp-security-guide.html#GUID-8CD65EF5-D113-4D5C-A564-B875C8625FAC">XML External Entity Injection Attack</a> </li>
  <li> W3C - <a href="https://www.w3.org/TR/xinclude-11/">XML Inclusions (XInclude) Version 1.1</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A4_2017-XML_External_Entities_(XXE)">Top 10 2017 - Category A4 - XML External
  Entities (XXE)</a> </li>
  <li> OWASP - <a href="https://owasp.org/Top10/A05_2021-Security_Misconfiguration/">Top 10 2021 - Category A5 - Security Misconfiguration</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/611">CWE-611 - Improper Restriction of XML External Entity Reference</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/827">CWE-827 - Improper Control of Document Type Definition</a> </li>
</ul>