# Description
Detects lines containing only punctuation.

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#close-brackets-at-line-end
https://docs.abapopenchecks.org/checks/16/

# Examples
**Bad example**
```abap
zcl_class=>method(
).
```

**Good example**
```abap
zcl_class=>method( ).
```

# Clean ABAP Code Style Guide
```ABAP
modify->update( node           = if_fra_alert_c=>node-item
                key            = item->key
                data           = item
                changed_fields = changed_fields ).
```

instead of the needlessly longer

```ABAP
" anti-pattern
modify->update( node           = if_fra_alert_c=>node-item
                key            = item->key
                data           = item
                changed_fields = changed_fields
).
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/line_only_punc) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
