# Description
Reports errors if the current class or interface references itself with `current_class=>`

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#omit-the-self-reference-me-when-calling-an-instance-attribute-or-method

# Clean ABAP Code Style Guide
Since the self-reference `me->` is implicitly set by the system, omit it when calling an instance attribute or method

```ABAP
DATA(sum) = aggregate_values( values ).
```

instead of the needlessly longer

```ABAP
" anti-pattern
DATA(sum) = aggregate_values( me->values ).
```

```ABAP
" anti-pattern
DATA(sum) = me->aggregate_values( values ).
```

unless there is a scope conflict between a local variable or importing parameter and an instance attribute

```ABAP
me->logger = logger.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/prefix_is_current_class) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
