Encryption in general is typically critical to the security of many
applications.  Using TLS can greatly increase security by guaranteeing the
identity of the party you are communicating with.  This is accomplished by one
or both parties presenting trusted certificates during the connection
initialization phase of TLS.

When HTTPS request methods are used, certificates are validated automatically
which is the desired behavior.  If certificate validation is explicitly turned
off Bandit will return a HIGH severity error.


## Example


In the following code snippet the issue is: [request_with_no_cert_validation] Call to requests with
verify=False disabling SSL certificate checks, security issue.
For more information on this see: CWE-295 (https://cwe.mitre.org/data/definitions/295.html)
``` python
  requests.get('https://gmail.com', verify=True)
  requests.get('https://gmail.com', verify=False)
  requests.post('https://gmail.com', verify=True)
```
## see also:

- https://security.openstack.org/guidelines/dg_move-data-securely.html
- https://security.openstack.org/guidelines/dg_validate-certificates.html
- https://cwe.mitre.org/data/definitions/295.html

New in version  0.9.0

Changed in version  1.7.3
CWE information added

Changed in version  1.7.5
Added check for httpx module
