
**DON'T** have a library name in a `library` declaration.

Library names are not necessary.

A library does not need a library declaration, but one can be added to attach
library documentation and library metadata to. A declaration of `library;` is
sufficient for those uses.

The only *use* of a library name is for a `part` file to refer back to its
owning library, but part files should prefer to use a string URI to refer back
to the library file, not a library name.

If a library name is added to a library declaration, it introduces the risk of
name *conflicts*. It's a compile-time error if two libraries in the same program
have the same library name. To avoid that, library names tend to be long,
including the package name and path, just to avoid accidental name clashes. That
makes such library names hard to read, and not even useful as documentation.

**BAD:**
```dart
/// This library has a long name.
library magnificator.src.helper.bananas;
```

```dart
library utils; // Not as verbose, but risks conflicts.
```

**GOOD:**
```dart
/// This library is awesome.
library;

part "apart.dart"; // contains: `part of "good_library.dart";`
```