Ensures that input bindings, including aliases, are not named or prefixed by the configured disallowed prefixes

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  inputs: ['on']
           ~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  outputs: [onCredit],
  'inputs': [onLevel, `test: on`, onFunction()],
                      ~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  ['inputs']: ['onTest: test', ...onArray],
               ~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  [`inputs`]: ['onTest: test', ...onArray],
               ~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Input() on: EventEmitter<any> = new EventEmitter<{}>();
           ~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  @Input() @Custom('on') 'onPrefix' = new EventEmitter<void>();
                         ~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Custom() @Input(`on`) _on = getInput();
                   ~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Custom() @Input({ required: true, alias: `on` }) _on = getInput();
                                            ~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  @Input('onPrefix') _on = (this.subject$ as Subject<{on: boolean}>).pipe();
         ~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  @Input({ alias: 'onPrefix', required: true }) _on = (this.subject$ as Subject<{on: boolean}>).pipe();
                  ~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Input('setter') set 'on-setter'() {}
                       ~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  @Input('on') isPrefix = this.getInput();
         ~~~~  ~~~~~~~~
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Page({
  inputs: ['on', onChange, \`onLine\`, 'on: on2', 'offline: on', ...onCheck, onInput()],
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  on = new EventEmitter();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  @Input() buttonChange = new EventEmitter<'on'>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  @Input() On = new EventEmitter<{ on: onType }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  @Input(\`one\`) ontype = new EventEmitter<{ bar: string, on: boolean }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  @Input({ alias: \`one\` }) ontype = new EventEmitter<{ bar: string, on: boolean }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  @Input('oneProp') common = new EventEmitter<ComplextOn>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  @Input({ alias: 'oneProp' }) common = new EventEmitter<ComplextOn>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test<On> {
  @Input() ON = new EventEmitter<On>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const on = 'on';
@Component()
class Test {
  @Input(on) touchMove: EventEmitter<{ action: 'on' | 'off' }> = new EventEmitter<{ action: 'on' | 'off' }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const test = 'on';
const on = 'on';
@Directive()
class Test {
  @Input(test) [on]: EventEmitter<OnTest>;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'foo',
})
class Test {
  @Input() set 'setter'() {}
}
```

</details>
