Disallows usage of the `inputs` metadata property. See more at https://angular.io/styleguide#style-05-12

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  inputs: [
  ~~~~~~~~~
    'id: foo'
  ],
  ~
  selector: 'app-test'
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  inputs: [
  ~~~~~~~~~
    'id: foo'
  ],
  ~
  selector: 'app-test'
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  inputs,
  ~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  inputs: [],
  ~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const test = [];
@Component({
  'inputs': test,
  ~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  ['inputs']: undefined,
  ~~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
function inputs() {
  return [];
}

@Component({
  [`inputs`]: inputs(),
  ~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const options = {};
@Component(options)
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'app-test',
  template: 'Hello'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'app-test',
  queries: {},
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const inputs = 'providers';
@Directive({
  [inputs]: [],
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  bootstrap: [Foo]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'qx-menuitem',
  hostDirectives: [{
    directive: CdkMenuItem,
    inputs: ['cdkMenuItemDisabled: disabled'],
  }]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'qx-menuitem',
  'hostDirectives': [{
    directive: CdkMenuItem,
    inputs: ['cdkMenuItemDisabled: disabled'],
  }]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'qx-menuitem',
  ['hostDirectives']: [{
    directive: CdkMenuItem,
    inputs: ['cdkMenuItemDisabled: disabled'],
  }]
})
class Test {}
```

</details>
