Ensures that $localize tagged messages contain helpful metadata to aid with translations.

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
const localizedText = $localize`Hello i18n!`;
                               ~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const localizedTexts = {
  helloI18n: $localize`:An introduction header for this sample:Hello i18n!`
};
localizedTexts.helloI18n = $localize`Hello i18n!`;
                                    ~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
return $localize`Hello i18n!`;
                ~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
someFunction($localize`Hello i18n!`);
                      ~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const localizedText = $localize`:site header|:Hello i18n!`;
                               ~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const localizedText = $localize`:@@custom_id:Hello i18n!`;
                               ~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const localizedText = $localize`:site header|@@custom_id:Hello i18n!`;
                               ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const localizedText = $localize`Hello i18n!`;
                               ~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const localizedText = $localize`:An introduction header for this sample:Hello i18n!`;
                               ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const localizedText = $localize`:|An introduction header for this sample:Hello i18n!`;
                               ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const localizedText = $localize`:Hello i18n!`;
                               ~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
const localizedText = $localize`Hello i18n!`;
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const localizedText = $localize`:site header|:Hello i18n!`;
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const localizedText = $localize`:@@custom_id:Hello i18n!`;
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const localizedText = $localize`:site header|@@custom_id:Hello i18n!`;
```

<br>

---

<br>

#### ✅ Valid Code

```ts
let localizedText = $localize\`:An introduction header for this sample:Hello i18n!\`;
localizedText = $localize\`:An introduction header for this sample modified:Hello i18n modified!\`;
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const localizedTexts = {
  helloI18n: $localize\`:An introduction header for this sample:Hello i18n!\`
};
localizedTexts.helloI18n = $localize\`:An introduction header for this sample modified:Hello i18n modified!\`;
```

<br>

---

<br>

#### ✅ Valid Code

```ts
return $localize\`:An introduction header for this sample:Hello i18n!\`;
```

<br>

---

<br>

#### ✅ Valid Code

```ts
someFunction($localize\`:An introduction header for this sample:Hello i18n!\`);
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const localizedText = \`Hello i18n!\`;
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const localizedText = $localize\`:site header|:Hello i18n!\`;
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const localizedText = $localize\`:site header|An introduction header for this sample:Hello i18n!\`;
```

</details>
