Ensures ASC alphabetical order for `NgModule` metadata arrays for easy visual scanning

- Type: suggestion
- 🔧 Supports autofix (`--fix`)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  imports: [aModule, bModule, DModule, cModule]
                                       ~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  'declarations': [
    AComponent,
    cPipe,
    bDirective,
    ~~~~~~~~~~
    DComponent,
  ],
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  ['exports']: [
    AComponent,
    cPipe,
    bDirective,
    ~~~~~~~~~~
    DComponent,
  ],
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  [`bootstrap`]: [
    AppModule2,
    AppModule3,
    AppModule1,
    ~~~~~~~~~~
  ]
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  schemas: [
    A_SCHEMA,
    C_SCHEMA,
    B_SCHEMA,
    ~~~~~~~~
  ]
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  providers: [
    AProvider,
    {
      provide: 'myprovider',
      useClass: MyProvider,
    },
    cProvider,
    bProvider,
    ~~~~~~~~~
    DProvider,
  ]
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  bootstrap,
  declarations: declarations,
  providers: providers(),
  schemas: [],
  [imports]: [
    aModule,
    bModule,
    DModule,
    cModule,
    ~~~~~~~
  ],
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  imports: [chModule, dModule]
                      ~~~~~~~
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule()
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const options = {};
@NgModule(options)
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  bootstrap: [
    AppModule1,
    AppModule2,
    AppModule3,
  ],
  'declarations': [
    AComponent,
    bDirective,
    cPipe,
    DComponent,
    VariableComponent,
  ],
  ['imports']: [
    _foo,
    AModule,
    bModule,
    cModule,
    DModule,
  ],
  [`providers`]: [
    AProvider,
    {
      provide: 'myprovider',
      useClass: MyProvider,
    },
    bProvider,
    cProvider,
    DProvider,
  ],
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  providers: [
    DeclarationD,
    DeclarationA,
  ]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  providers: [
    {
      provide: 'myprovider',
      useFactory: myProviderFactory,
      deps: [TOKEN_Z, ClassX, ClassA, TOKEN_A],
    },
  ],
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  providers: [
    DatepickerProvider,
    ChipsProvider,
  ]
})
class Test {}
```

</details>
