Ensures that a button has a valid type specified

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<button></button>
~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<button (click)="onClick()"></button>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<button type="whatever"></button>
        ~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<button [attr.type]="'whatever'"></button>
        ~~~~~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<button [attr.type]="'button'"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button [attr.type]="'submit'"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button [attr.type]="'reset'"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button type="button"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button type="submit"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button type="reset"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button class="primary" type="submit"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button (click)="onClick()" type="button"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button [class.primary]="true" [attr.type]="'submit'"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button [disabled]="true" [attr.type]="'button'"></button>
```

</details>
